/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.common.control.IControl;
import wanion.lib.common.control.IControlNameable;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;

public class Matching
implements IControl<Matching>,
IControlNameable {
    private final List<ItemStack> itemStacks;
    private final int number;
    private final String stringNumber;
    private final boolean shouldUseNbt;
    private AbstractMatcher matcher = new ItemStackMatcher(this);

    public Matching(@Nonnull List<ItemStack> itemStacks, int number) {
        this(itemStacks, number, false);
    }

    public Matching(@Nonnull List<ItemStack> itemStacks, int number, boolean shouldUseNbt) {
        this.itemStacks = itemStacks;
        this.number = number;
        this.stringNumber = Integer.toString(this.number);
        this.shouldUseNbt = shouldUseNbt;
    }

    public void resetMatcher() {
        this.matcher = new ItemStackMatcher(this);
    }

    public void nextMatcher() {
        this.matcher = this.matcher.next();
    }

    public AbstractMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(@Nonnull AbstractMatcher matcher) {
        this.matcher = matcher.validate();
    }

    public ItemStack getStack() {
        return this.itemStacks.get(this.number);
    }

    public boolean shouldUseNbt() {
        return this.shouldUseNbt;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (!nbtTagCompound.func_74764_b("Matching")) {
            nbtTagCompound.func_74782_a("Matching", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound subCompound = nbtTagCompound.func_74775_l("Matching");
        NBTTagCompound matchingCompound = new NBTTagCompound();
        matchingCompound.func_74768_a("matcherType", this.matcher.getMatcherEnum().ordinal());
        this.matcher.writeToNBT(matchingCompound);
        subCompound.func_74782_a(this.stringNumber, (NBTBase)matchingCompound);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        NBTTagCompound subCompound;
        if (nbtTagCompound.func_74764_b("Matching") && (subCompound = nbtTagCompound.func_74775_l("Matching")).func_74764_b(this.stringNumber)) {
            NBTTagCompound matchingCompound = subCompound.func_74775_l(this.stringNumber);
            MatcherEnum matcherEnum = MatcherEnum.values()[matchingCompound.func_74762_e("matcherType")];
            AbstractMatcher matcher = matcherEnum.getMatcher(this);
            matcher.readFromNBT(matchingCompound);
            this.setMatcher(matcher);
        }
    }

    @Override
    @Nonnull
    public Matching copy() {
        Matching matching = new Matching(this.itemStacks, this.number);
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.writeToNBT(nbtTagCompound);
        matching.readFromNBT(nbtTagCompound);
        return matching;
    }

    @Override
    @Nonnull
    public String getControlName() {
        return "wanionlib.matching.control";
    }

    public int hashCode() {
        return this.number;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Matching) {
            Matching matching = (Matching)obj;
            if (matching.number == this.number) {
                return this.matcher.equals(matching.matcher);
            }
            return false;
        }
        return false;
    }
}

