/*
 * Decompiled with CFR 0.152.
 */
package net.ellertonCMMShade.japng;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.ellertonCMMShade.japng.PngFilter;
import net.ellertonCMMShade.japng.chunks.PngHeader;
import net.ellertonCMMShade.japng.error.PngException;
import net.ellertonCMMShade.japng.reader.PngScanlineProcessor;

public class PngScanlineBuffer {
    protected final byte[] bytes;
    protected final int filterUnit;
    protected byte[] previousLine;
    protected int readPosition;
    protected int writePosition;

    public PngScanlineBuffer(int size, int maxBytesPerLine, int filterUnit) {
        this.bytes = new byte[size];
        this.previousLine = new byte[maxBytesPerLine];
        this.filterUnit = filterUnit;
        this.reset();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getReadPosition() {
        return this.readPosition;
    }

    public int getWritePosition() {
        return this.writePosition;
    }

    public boolean canRead(int minNumBytes) {
        return this.availableRead() >= minNumBytes;
    }

    public int availableRead() {
        return this.writePosition - this.readPosition;
    }

    public int availableWrite() {
        return this.bytes.length - this.writePosition;
    }

    public void skip(int numBytes) {
        if (numBytes < 0 || numBytes > this.availableRead()) {
            throw new IllegalArgumentException(String.format("Skip bytes must be 0 > n >= %d: %d", this.availableRead(), numBytes));
        }
        this.readPosition += numBytes;
    }

    public void reset() {
        this.readPosition = 0;
        this.writePosition = 0;
        Arrays.fill(this.previousLine, (byte)0);
    }

    public void shift() {
        int len = this.availableRead();
        System.arraycopy(this.bytes, this.readPosition, this.bytes, 0, len);
        this.writePosition = len;
        this.readPosition = 0;
    }

    public int read(InputStream is) throws IOException {
        int r = is.read(this.bytes, this.writePosition, this.availableWrite());
        if (r > 0) {
            this.writePosition += r;
        }
        return r;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decompress(InputStream inputStream, PngScanlineProcessor processor) throws IOException, PngException {
        int bytesPerLine = processor.getBytesPerLine();
        try (FilterInputStream iis = processor.makeInflaterInputStream(inputStream);){
            while (true) {
                int len;
                if ((len = this.read(iis)) <= 0) {
                    boolean bl = processor.isFinished();
                    return bl;
                }
                while (this.canRead(bytesPerLine)) {
                    this.undoFilterScanline(bytesPerLine);
                    processor.processScanline(this.bytes, this.readPosition + 1);
                    this.skip(bytesPerLine);
                }
                this.shift();
                continue;
                break;
            }
        }
    }

    public void undoFilterScanline(int bytesPerLine) {
        byte filterCode = this.bytes[this.readPosition];
        switch (filterCode) {
            case 0: {
                break;
            }
            case 1: {
                PngFilter.undoSubFilter(this.bytes, this.readPosition + 1, this.readPosition + bytesPerLine, this.filterUnit, this.previousLine);
                break;
            }
            case 2: {
                PngFilter.undoUpFilter(this.bytes, this.readPosition + 1, this.readPosition + bytesPerLine, this.filterUnit, this.previousLine);
                break;
            }
            case 3: {
                PngFilter.undoAverageFilter(this.bytes, this.readPosition + 1, this.readPosition + bytesPerLine, this.filterUnit, this.previousLine);
                break;
            }
            case 4: {
                PngFilter.undoPaethFilter(this.bytes, this.readPosition + 1, this.readPosition + bytesPerLine, this.filterUnit, this.previousLine);
                break;
            }
        }
        System.arraycopy(this.bytes, this.readPosition + 1, this.previousLine, 0, bytesPerLine - 1);
    }

    public static PngScanlineBuffer from(PngHeader header) {
        return PngScanlineBuffer.from(header, 32768);
    }

    public static PngScanlineBuffer from(PngHeader header, int minBufferSize) {
        return new PngScanlineBuffer(PngScanlineBuffer.sizeFrom(header, minBufferSize), header.bytesPerRow, header.filterOffset);
    }

    public static int sizeFrom(PngHeader header, int minBufferSize) {
        int bytesPerRow = header.bytesPerRow;
        int bytesFullBitmap = bytesPerRow * header.height;
        if (bytesFullBitmap < minBufferSize) {
            return bytesFullBitmap;
        }
        int numRows = Math.max(1, minBufferSize / bytesPerRow);
        return numRows * bytesPerRow;
    }
}

