/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ObfuscatedKeyMap<V> {
    private final int seed;
    private final int max_search;
    private final TIntObjectHashMap<SubEntry<V>> map;

    public ObfuscatedKeyMap(int seed, int max_search, TIntObjectHashMap<SubEntry<V>> map) {
        this.seed = seed;
        this.max_search = max_search;
        this.map = map;
    }

    public static <V> ObfuscatedKeyMap<V> compile(Map<String, V> map, int seed) {
        TIntObjectHashMap hashMap = new TIntObjectHashMap();
        int max_len = 1;
        if (map.containsKey("")) {
            hashMap.put(0, new SubEntry<V>(map.get(""), 0, 0));
        }
        for (Map.Entry<String, V> entry2 : map.entrySet()) {
            String key = entry2.getKey();
            int potentialHash = seed;
            int p = 0;
            int i = 0;
            while (true) {
                if (!hashMap.containsKey(potentialHash = potentialHash * 63 + p * 31 + key.charAt(i))) break;
                if (++i >= key.length()) {
                    i = 0;
                }
                ++p;
            }
            hashMap.put(potentialHash, new SubEntry<V>(entry2.getKey(), entry2.getValue()));
            max_len = Math.max(max_len, p + 1);
        }
        return new ObfuscatedKeyMap<V>(seed, max_len, hashMap);
    }

    @Nullable
    public V get(String key) {
        if (key.isEmpty()) {
            SubEntry subEntry = (SubEntry)this.map.get(0);
            if (subEntry.length == 0 && subEntry.altHash == 0) {
                return (V)subEntry.value;
            }
            return null;
        }
        int hash = key.hashCode();
        int potentialHash = this.seed;
        byte length = (byte)key.length();
        int i = 0;
        for (int p = 0; p < this.max_search; ++p) {
            SubEntry v = (SubEntry)this.map.get(potentialHash = potentialHash * 63 + p * 31 + key.charAt(i));
            if (v == null) {
                return null;
            }
            if (length == v.length && hash == v.altHash) {
                return (V)v.value;
            }
            if (++i < key.length()) continue;
            i = 0;
        }
        return null;
    }

    private static class SubEntry<T> {
        T value;
        byte length;
        int altHash;

        public SubEntry(String key, T value) {
            this(value, (byte)key.length(), key.hashCode());
        }

        public SubEntry(T value, byte length, int altHash) {
            this.value = value;
            this.length = length;
            this.altHash = altHash;
        }
    }
}

