/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui;

import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.GuiHandler;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonText;
import com.rwtema.extrautils2.gui.backend.WidgetRawData;
import com.rwtema.extrautils2.gui.backend.WidgetScrollBar;
import com.rwtema.extrautils2.gui.backend.WidgetText;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.utils.Lang;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerPlayerAlliances
extends DynamicContainer {
    public static IDynamicHandler handler = (ID1, player, world, x, y, z) -> new ContainerPlayerAlliances(player);
    public static int ID;
    final WidgetScrollBar scrollBar;
    final int NUM_VERTICAL_ENTRIES = 10;
    final int BUTTON_HEIGHT = 20;
    final int BUTTON_WIDTH = 180;
    public ArrayList<PlayerEntry> entryList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerPlayerAlliances(final EntityPlayer player) {
        EntityPlayerMP playerMP = player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null;
        final int freq = playerMP != null ? Freq.getBasePlayerFreq(playerMP) : 0;
        final PowerManager manager = PowerManager.instance;
        if (playerMP != null && ExtraUtils2.deobf_folder) {
            Object object = PowerManager.MUTEX;
            synchronized (object) {
                manager.frequncies.put(343, (Object)new GameProfile(UUID.randomUUID(), "Frank"));
                manager.frequncies.put(432132, (Object)new GameProfile(UUID.randomUUID(), "Tim"));
                manager.frequncies.put(432133, (Object)new GameProfile(UUID.randomUUID(), "Tom"));
                manager.frequncies.put(65396, (Object)new GameProfile(UUID.randomUUID(), "Katey"));
                manager.frequncies.put(322, (Object)new GameProfile(UUID.randomUUID(), "Sandy"));
                manager.frequncies.put(544, (Object)new GameProfile(UUID.randomUUID(), "Oscar"));
                manager.frequncies.put(5441, (Object)new GameProfile(UUID.randomUUID(), "Roger"));
                manager.frequncies.put(3223, (Object)new GameProfile(UUID.randomUUID(), "Olgoth the Destroyer"));
                TIntHashSet set = new TIntHashSet();
                set.add(freq);
                set.add(322);
                manager.alliances.put(343, (Object)set);
                set = new TIntHashSet();
                set.add(343);
                manager.alliances.put(322, (Object)set);
                manager.reassignValues();
            }
        }
        this.addWidget(new WidgetRawData(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addToDescription(XUPacketBuffer packet) {
                final ArrayList entryList = new ArrayList();
                Iterator iterator = PowerManager.MUTEX;
                synchronized (iterator) {
                    manager.frequncies.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<GameProfile>(){

                        public boolean execute(int a, GameProfile b) {
                            if (b.equals((Object)player.func_146103_bH())) {
                                return true;
                            }
                            entryList.add(new PlayerEntry(b, a, manager.doesAWishToAllyWithB(a, freq), manager.doesAWishToAllyWithB(freq, a), manager.sameTeam(a, freq)));
                            return true;
                        }
                    });
                }
                packet.writeShort(entryList.size());
                for (PlayerEntry entry2 : entryList) {
                    packet.writeProfile(entry2.profile);
                    packet.writeInt(entry2.freq);
                    packet.writeBoolean(entry2.themAlliedWithYou);
                    packet.writeBoolean(entry2.youAlliedWithThem);
                    packet.writeBoolean(entry2.sameTeam);
                }
            }

            @Override
            public void handleDescriptionPacket(XUPacketBuffer packet) {
                ArrayList<PlayerEntry> list = new ArrayList<PlayerEntry>();
                list.clear();
                int n = packet.readUnsignedShort();
                for (int i = 0; i < n; ++i) {
                    GameProfile profile = packet.readProfile();
                    int freq2 = packet.readInt();
                    boolean them = packet.readBoolean();
                    boolean you = packet.readBoolean();
                    boolean sameTeam = packet.readBoolean();
                    list.add(new PlayerEntry(profile, freq2, them, you, sameTeam));
                }
                Collections.sort(list);
                ContainerPlayerAlliances.this.entryList = list;
                ContainerPlayerAlliances.this.scrollBar.setValues(0, Math.max(0, n - 10 + 1));
                ContainerPlayerAlliances.this.scrollBar.reScroll();
            }
        });
        this.scrollBar = new WidgetScrollBar(188, 17, 200, 0, 0);
        this.addWidget(this.scrollBar);
        this.addWidget(new WidgetText(4, 4, Lang.translate("Select players to share power with."), 198));
        for (int i = 0; i < 10; ++i) {
            final int k = i;
            this.addWidget(new WidgetClickMCButtonText("", 4, 17 + i * 20, 180, 20){

                @Override
                @Nullable
                public XUPacketBuffer getPacketToSend(int mouseButton) {
                    XUPacketBuffer pkt = new XUPacketBuffer();
                    PlayerEntry ref = this.getEntry();
                    if (ref == null) {
                        return null;
                    }
                    pkt.writeInt(ref.freq);
                    return pkt;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveClientPacket(XUPacketBuffer buffer) {
                    int otherFreq = buffer.readInt();
                    if (!manager.frequncies.containsKey(otherFreq)) {
                        return;
                    }
                    Object object = PowerManager.MUTEX;
                    synchronized (object) {
                        TIntHashSet set = (TIntHashSet)manager.alliances.get(freq);
                        if (set == null) {
                            set = new TIntHashSet();
                            manager.alliances.put(freq, (Object)set);
                        }
                        if (set.contains(otherFreq)) {
                            set.remove(otherFreq);
                        } else {
                            set.add(otherFreq);
                        }
                        manager.reassignValues();
                    }
                }

                public PlayerEntry getEntry() {
                    int j = k + ContainerPlayerAlliances.this.scrollBar.scrollValue;
                    if (j < 0) {
                        this.visible = false;
                        return null;
                    }
                    ArrayList<PlayerEntry> list = ContainerPlayerAlliances.this.entryList;
                    if (j < list.size()) {
                        this.visible = true;
                        return list.get(j);
                    }
                    this.visible = false;
                    return null;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void renderButtonText(DynamicGui gui, FontRenderer fontrenderer, int xPosition, int yPosition, int color) {
                    PlayerEntry entry2 = this.getEntry();
                    if (entry2 == null) {
                        return;
                    }
                    StringBuilder builder = new StringBuilder();
                    if (entry2.youAlliedWithThem) {
                        builder.append("[");
                        builder.append(entry2.getName());
                        builder.append("]");
                    } else {
                        builder.append(entry2.getName());
                    }
                    builder.append(" ");
                    builder.append(entry2.sameTeam ? Lang.translate("[Sharing]") : "");
                    String text = builder.toString();
                    gui.func_73732_a(fontrenderer, text, xPosition + this.getW() / 2, yPosition + (this.getH() - 8) / 2, color);
                }
            });
        }
        this.crop();
        this.addWidget((IWidget)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<Boolean>(4, this.height){

            @Override
            protected void onSelectedServer(Boolean marker) {
                if (marker.booleanValue()) {
                    PowerManager.instance.lockedFrequencies.add(freq);
                } else {
                    PowerManager.instance.lockedFrequencies.remove(freq);
                }
            }

            @Override
            public Boolean getSelectedValue() {
                return PowerManager.instance.lockedFrequencies.contains(freq);
            }
        }.addChoice(Boolean.FALSE, Lang.translate("Secure Inventories"), ItemIngredients.Type.SYMBOL_CROSS.newStack(), Lang.translate("All players can currently access your inventories"))).addChoice((Boolean)Boolean.TRUE, Lang.translate("Secure Inventories"), ItemIngredients.Type.SYMBOL_TICK.newStack(), Lang.translate("Only players on your team can access your inventories")));
        this.crop();
        this.validate();
    }

    public static void init() {
        ID = GuiHandler.register("Alliances", handler);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    public static class PlayerEntry
    implements Comparable<PlayerEntry> {
        private final int freq;
        GameProfile profile;
        boolean themAlliedWithYou;
        boolean youAlliedWithThem;
        boolean sameTeam;

        public PlayerEntry(GameProfile profile, int freq, boolean themAlliedWithYou, boolean youAlliedWithThem, boolean sameTeam) {
            this.profile = profile;
            this.freq = freq;
            this.themAlliedWithYou = themAlliedWithYou;
            this.youAlliedWithThem = youAlliedWithThem;
            this.sameTeam = sameTeam;
        }

        @Override
        public int compareTo(@Nonnull PlayerEntry o) {
            String nameA = this.getName();
            String nameB = o.getName();
            return nameA.compareTo(nameB);
        }

        @Nonnull
        public String getName() {
            String name = this.profile.getName();
            return name != null ? name : "";
        }
    }
}

