/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import alexiil.mc.mod.load.ClsManager;
import alexiil.mc.mod.load.CustomLoadingScreen;
import alexiil.mc.mod.load.progress.LongTermProgressTracker;
import alexiil.mc.mod.load.progress.SingleProgressBarTracker;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.common.ProgressManager;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class MainSplashRenderer {
    private static volatile boolean enableCustom = false;
    public static ResourceLocation fontLoc;
    public static volatile boolean pause;
    public static DummyTexture mojangLogoTex;
    private static FontRenderer fontRenderer;
    private static final Lock lock;
    private static final Semaphore mutex;
    private static long start;
    private static long diff;
    private static volatile boolean reachedConstruct;
    private static volatile boolean finishedLoading;

    public static long getTotalTime() {
        return diff;
    }

    private static <T> T get(Class<?> cls, String name, Class<T> type) {
        try {
            Field fld = cls.getDeclaredField(name);
            fld.setAccessible(true);
            return type.cast(fld.get(null));
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static void onReachConstruct() {
        if (!reachedConstruct) {
            try {
                enableCustom = ClsManager.load();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            reachedConstruct = true;
        }
    }

    public static void finish() {
        CustomLoadingScreen.finish();
        finishedLoading = true;
        lock.lock();
    }

    public static void run() {
        fontRenderer = MainSplashRenderer.get(SplashProgress.class, "fontRenderer", FontRenderer.class);
        boolean transitionOutDone = false;
        start = System.currentTimeMillis();
        while (!transitionOutDone) {
            GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)16384);
            int w = Display.getWidth();
            int h = Display.getHeight();
            GL11.glViewport((int)0, (int)0, (int)w, (int)h);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)(-w / 2), (double)(w / 2), (double)(h / 2), (double)(-h / 2), (double)-1.0, (double)1.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            diff = System.currentTimeMillis() - start;
            if (diff < 2500L || !reachedConstruct) {
                MainSplashRenderer.renderMojangFrame();
            } else if (!finishedLoading) {
                MainSplashRenderer.renderFrame();
            } else {
                transitionOutDone = MainSplashRenderer.renderTransitionFrame();
            }
            mutex.acquireUninterruptibly();
            Display.update();
            mutex.release();
            GL11.glFlush();
            if (finishedLoading && !reachedConstruct) break;
            Display.sync((int)100);
            boolean grabUngrab = pause;
            if (grabUngrab) {
                MainSplashRenderer.clearGL();
            }
            if (!grabUngrab) continue;
            MainSplashRenderer.setGL();
        }
        LongTermProgressTracker.save(SingleProgressBarTracker.getProgressSections());
        MainSplashRenderer.clearGL();
    }

    private static void renderMojangFrame() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        mojangLogoTex.bind();
        GL11.glBegin((int)7);
        mojangLogoTex.texCoord(0, 0.0f, 0.0f);
        GL11.glVertex2f((float)-256.0f, (float)-256.0f);
        mojangLogoTex.texCoord(0, 0.0f, 1.0f);
        GL11.glVertex2f((float)-256.0f, (float)256.0f);
        mojangLogoTex.texCoord(0, 1.0f, 1.0f);
        GL11.glVertex2f((float)256.0f, (float)256.0f);
        mojangLogoTex.texCoord(0, 1.0f, 0.0f);
        GL11.glVertex2f((float)256.0f, (float)-256.0f);
        GL11.glEnd();
        GL11.glDisable((int)3553);
    }

    private static void renderFrame() {
        if (enableCustom) {
            ClsManager.renderFrame();
        } else {
            double progress;
            String subStatus;
            String status;
            try (SingleProgressBarTracker.LockUnlocker u = SingleProgressBarTracker.lockUpdate();){
                status = SingleProgressBarTracker.getStatusText();
                subStatus = SingleProgressBarTracker.getSubStatus();
                progress = (double)SingleProgressBarTracker.getProgress() / 1048576.0;
            }
            int y = 0;
            GL11.glColor3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glPushMatrix();
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            String s = (double)(diff / 100L) / 10.0 + "s";
            fontRenderer.func_78276_b(s, 0, -10, 0);
            s = status + " - " + subStatus;
            fontRenderer.func_78276_b(s, -fontRenderer.func_78256_a(s) / 2, -40, 0);
            String bar = MainSplashRenderer.getProgress(12, progress);
            fontRenderer.func_78276_b(bar, -fontRenderer.func_78256_a(bar) / 2, -30, 0);
            Iterator i = ProgressManager.barIterator();
            while (i.hasNext()) {
                ProgressManager.ProgressBar b = (ProgressManager.ProgressBar)i.next();
                int startWidth = fontRenderer.func_78256_a(b.getTitle() + " ");
                fontRenderer.func_78276_b(b.getTitle() + " ", -startWidth, y, 0);
                fontRenderer.func_78276_b("- " + b.getMessage(), 0, y, 0);
                bar = MainSplashRenderer.getProgress(b);
                fontRenderer.func_78276_b(bar, -fontRenderer.func_78256_a(bar) / 2, y + 14, 0);
                y += 30;
            }
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            String[] list = new String[]{String.format("Mem: % 2d%% %03d/%03dMB", used * 100L / max, MainSplashRenderer.bytesToMb(used), MainSplashRenderer.bytesToMb(max)), String.format("Allocated: % 2d%% %03dMB", total * 100L / max, MainSplashRenderer.bytesToMb(total))};
            int w = Display.getWidth();
            int h = Display.getHeight();
            int x = -w / 4;
            y = -h / 4;
            for (String s2 : list) {
                fontRenderer.func_78276_b(s2, x, y, 0);
                y += 20;
            }
            GL11.glDisable((int)3553);
            GL11.glPopMatrix();
        }
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private static boolean renderTransitionFrame() {
        if (enableCustom) {
            return ClsManager.renderTransitionFrame();
        }
        MainSplashRenderer.renderFrame();
        return true;
    }

    private static String getProgress(ProgressManager.ProgressBar bar) {
        return MainSplashRenderer.getProgress(8, (double)bar.getStep() / (double)bar.getSteps());
    }

    private static String getProgress(int gaps, double perc) {
        int i;
        String s = "[";
        double val = (double)gaps * perc;
        int count = (int)val;
        boolean endBig = val % 1.0 > 0.5;
        for (i = 0; i < count; ++i) {
            s = s + "=";
        }
        if (endBig & count < gaps) {
            ++count;
            s = s + ">";
        }
        for (i = count; i < gaps; ++i) {
            s = s + "-";
        }
        return s + "]";
    }

    private static void setGL() {
        lock.lock();
        try {
            Display.getDrawable().makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private static void clearGL() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71443_c = Display.getWidth();
        mc.field_71440_d = Display.getHeight();
        mc.func_71370_a(mc.field_71443_c, mc.field_71440_d);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        try {
            Display.getDrawable().releaseContext();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    static {
        pause = false;
        reachedConstruct = false;
        finishedLoading = false;
        lock = MainSplashRenderer.get(SplashProgress.class, "lock", Lock.class);
        mutex = MainSplashRenderer.get(SplashProgress.class, "mutex", Semaphore.class);
    }

    public static class DummyTexture {
        public void bind() {
        }

        public void texCoord(int i, float f, float f2) {
        }
    }
}

