/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.transform.EnderCorePlugin;
import com.enderio.core.common.transform.NoClassloadClassWriter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SimpleMixinPatcher
implements IClassTransformer {
    private final EnderCorePlugin plugin = EnderCorePlugin.instance();
    private final Map<String, byte[]> capturedSources = new HashMap<String, byte[]>();
    private final Multimap<String, EnderCorePlugin.MixinData> interfaceTargets = HashMultimap.create();

    public byte[] transform(String name, String transformedName, byte[] targetClass) {
        if (targetClass == null) {
            return targetClass;
        }
        ArrayList<EnderCorePlugin.MixinData> patches = new ArrayList<EnderCorePlugin.MixinData>();
        for (EnderCorePlugin.MixinData d : this.plugin.mixins) {
            if (d.target.equals(transformedName)) {
                patches.add(d);
            }
            if (!d.source.equals(transformedName)) continue;
            this.capturedSources.put(transformedName, targetClass);
            EnderCorePlugin.mixinLogger.info("Found mixin source class data for {}.", (Object)transformedName);
        }
        if (patches.isEmpty() && this.interfaceTargets.isEmpty()) {
            return targetClass;
        }
        ClassNode targetNode = new ClassNode();
        ClassReader targetReader = new ClassReader(targetClass);
        targetReader.accept((ClassVisitor)targetNode, 0);
        if (!patches.isEmpty() && (targetNode.access & 0x200) != 0) {
            this.interfaceTargets.putAll((Object)targetNode.name, patches);
            EnderCorePlugin.mixinLogger.info("Found interface target {}", (Object)transformedName);
            return targetClass;
        }
        if (!this.interfaceTargets.isEmpty()) {
            int patchCount = patches.size();
            targetNode.interfaces.stream().map(arg_0 -> this.interfaceTargets.get(arg_0)).filter(Objects::nonNull).forEach(patches::addAll);
            if (patches.size() > patchCount) {
                int count = patches.size() - patchCount;
                EnderCorePlugin.mixinLogger.info("Found {} {} to apply to class {} from implemented interfaces: {}", (Object)count, (Object)(count > 1 ? "patches" : "patch"), (Object)transformedName, (Object)targetNode.interfaces.stream().filter(arg_0 -> this.interfaceTargets.containsKey(arg_0)).toArray());
            }
        }
        if (!patches.isEmpty()) {
            if (targetNode.visibleAnnotations != null && targetNode.visibleAnnotations.stream().anyMatch(n -> n.desc.contains("com/enderio/core/common/transform/SimpleMixin"))) {
                EnderCorePlugin.mixinLogger.info("Not mixing into class {} because it is itself a mixin", (Object)transformedName);
                return targetClass;
            }
            EnderCorePlugin.mixinLogger.info("Patching {} mixins onto class {}", (Object)patches.size(), (Object)transformedName);
            for (EnderCorePlugin.MixinData data : patches) {
                List newMethods;
                byte[] sourceClass = this.capturedSources.get(data.source);
                if (sourceClass == null) {
                    EnderCorePlugin.mixinLogger.error("Skipping mixin patch due to unloaded class: " + data.source);
                    continue;
                }
                ClassNode sourceNode = new ClassNode();
                ClassReader sourceReader = new ClassReader(sourceClass);
                sourceReader.accept((ClassVisitor)sourceNode, 0);
                Type targetType = Type.getObjectType((String)targetNode.name);
                for (MethodNode m2 : sourceNode.methods) {
                    for (AbstractInsnNode node : m2.instructions) {
                        if (!(node instanceof MethodInsnNode)) continue;
                        MethodInsnNode call = (MethodInsnNode)node;
                        if (!Type.getObjectType((String)call.owner).getClassName().equals(data.source)) continue;
                        call.owner = targetType.getInternalName();
                        if (call.getOpcode() != 185) continue;
                        call.setOpcode(182);
                        call.itf = false;
                    }
                    if (m2.localVariables.size() <= 0) continue;
                    LocalVariableNode n2 = (LocalVariableNode)m2.localVariables.get(0);
                    n2.desc = targetType.getDescriptor();
                }
                List newInterfaces = sourceNode.interfaces.stream().filter(s -> !targetNode.interfaces.contains(s)).collect(Collectors.toList());
                if (!newInterfaces.isEmpty()) {
                    targetNode.interfaces.addAll(newInterfaces);
                    EnderCorePlugin.mixinLogger.info("Added {} new {}: {}", (Object)newInterfaces.size(), (Object)(newInterfaces.size() == 1 ? "interface" : "interfaces"), newInterfaces);
                }
                if ((newMethods = sourceNode.methods.stream().filter(m -> !m.name.equals("<init>")).filter(m -> (m.access & 0x400) == 0).filter(m -> targetNode.methods.stream().filter(m2 -> m2.name.equals(m.name) && m2.desc.equals(m.desc)).count() == 0L).collect(Collectors.toList())).isEmpty()) continue;
                targetNode.methods.addAll(newMethods);
                EnderCorePlugin.mixinLogger.info("Added {} new {}: {}", (Object)newMethods.size(), (Object)(newMethods.size() == 1 ? "method" : "methods"), (Object)newMethods.stream().map(m -> m.name + m.desc).toArray());
            }
            NoClassloadClassWriter cw = new NoClassloadClassWriter(3);
            targetNode.accept((ClassVisitor)cw);
            EnderCorePlugin.mixinLogger.info("Successfully patched.");
            return cw.toByteArray();
        }
        return targetClass;
    }
}

