/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.client.renderer.block.canvas.ModelQuads;
import openmods.geometry.AabbBuilder;

class InnerModelInfo {
    public final Map<BlockRenderLayer, ModelQuads> layers;
    public final AxisAlignedBB bounds;
    public final int maxTint;

    private InnerModelInfo(Map<BlockRenderLayer, ModelQuads> layers, AxisAlignedBB aabb, int maxTint) {
        this.layers = layers;
        this.bounds = aabb;
        this.maxTint = maxTint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InnerModelInfo create(IBlockState blockState, IBakedModel baseModel, Predicate<BlockRenderLayer> shouldCheckLayer) {
        int maxTint = -1;
        AabbBuilder boundsBuilder = AabbBuilder.create();
        ImmutableMap.Builder layers = ImmutableMap.builder();
        BlockRenderLayer prevRenderLayer = MinecraftForgeClient.getRenderLayer();
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (shouldCheckLayer.apply((Object)layer)) {
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    ModelQuads.Builder builder = ModelQuads.builder();
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        List quads = baseModel.func_188616_a(blockState, side, 0L);
                        builder.addSidedQuads(side, quads);
                        maxTint = InnerModelInfo.processQuads(maxTint, boundsBuilder, quads);
                    }
                    List generalQuads = baseModel.func_188616_a(blockState, null, 0L);
                    maxTint = InnerModelInfo.processQuads(maxTint, boundsBuilder, generalQuads);
                    builder.addGeneralQuads(generalQuads);
                    layers.put((Object)layer, (Object)builder.build());
                    continue;
                }
                layers.put((Object)layer, (Object)ModelQuads.EMPTY);
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)prevRenderLayer);
        }
        return new InnerModelInfo((Map<BlockRenderLayer, ModelQuads>)layers.build(), boundsBuilder.build(), maxTint);
    }

    private static int processQuads(int maxTint, AabbBuilder boundsBuilder, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            maxTint = Math.max(maxTint, quad.func_178211_c());
            int[] vertexData = quad.func_178209_a();
            int vertexSize = quad.getFormat().func_181719_f();
            for (int i = 0; i < 4; ++i) {
                float x = Float.intBitsToFloat(vertexData[i * vertexSize + 0]);
                float y = Float.intBitsToFloat(vertexData[i * vertexSize + 1]);
                float z = Float.intBitsToFloat(vertexData[i * vertexSize + 2]);
                boundsBuilder.addPoint(x, y, z);
            }
        }
        return maxTint;
    }
}

