/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.registration.impl;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.RebornCore;
import reborncore.common.RebornCoreConfig;
import reborncore.common.registration.IRegistryFactory;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.RegistrationManager;
import reborncore.common.registration.RegistryConstructionEvent;
import reborncore.common.registration.RegistryTarget;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.serialization.SerializationUtil;

@IRegistryFactory.RegistryFactory
public class ConfigRegistryFactory
implements IRegistryFactory {
    private static File configDir = null;
    private static HashMap<String, Configuration> configMap = new HashMap();
    private static HashMap<Configuration, ConfigData> configDataMap = new HashMap();
    private static NBTTagCompound configVersionTag = null;

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return ConfigRegistry.class;
    }

    @Override
    public void handleField(Field field) {
        try {
            ConfigData configData;
            Object value;
            String key;
            RebornRegistry rebornRegistry = (RebornRegistry)RegistrationManager.getAnnoation(field.getDeclaringClass().getAnnotations(), RebornRegistry.class);
            ConfigRegistry annotation = (ConfigRegistry)RegistrationManager.getAnnoationFromArray(field.getAnnotations(), this);
            Configuration configuration = ConfigRegistryFactory.getOrCreateConfig(annotation, rebornRegistry);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new RuntimeException("Field " + field.getName() + " must be static");
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            if ((key = annotation.key()).isEmpty()) {
                key = field.getName();
            }
            Object defaultValue = field.get(null);
            String comment = annotation.comment();
            comment = comment + " [Default=" + defaultValue + "]";
            Property property = ConfigRegistryFactory.get(annotation.category(), key, defaultValue, comment, field.getType(), configuration);
            if (this.shouldReset(property, annotation, rebornRegistry.modID()) && RebornCoreConfig.configUpdating) {
                property.setToDefault();
            }
            try {
                value = ConfigRegistryFactory.getObjectFromProperty(property, field);
            }
            catch (Exception e) {
                RebornCore.logHelper.error("Failed to read config value " + annotation.category() + "." + annotation.key() + " resetting to default value");
                e.printStackTrace();
                value = defaultValue;
            }
            field.set(null, value);
            if (configDataMap.containsKey(configuration)) {
                configData = configDataMap.get(configuration);
            } else {
                configData = new ConfigData(configuration);
                configDataMap.put(configuration, configData);
            }
            configData.fieldMap.put(configData.getName(annotation.category(), property), field);
        }
        catch (IllegalAccessException e) {
            throw new Error("Failed to load config", e);
        }
    }

    @Override
    public void factoryComplete() {
        MinecraftForge.EVENT_BUS.post((Event)new RebornRegistryEvent());
        ConfigRegistryFactory.saveAll();
    }

    private static Object getObjectFromProperty(Property property, @Nullable Field field) {
        if (property.getType() == Property.Type.STRING) {
            if (property.isList()) {
                return ConfigRegistryFactory.getList(property, field);
            }
            return property.getString();
        }
        if (property.getType() == Property.Type.BOOLEAN) {
            return property.getBoolean();
        }
        if (property.getType() == Property.Type.INTEGER) {
            return property.getInt();
        }
        if (property.getType() == Property.Type.DOUBLE) {
            return property.getDouble();
        }
        throw new RuntimeException("Type not supported");
    }

    public static Property get(String category, String key, Object defaultValue, String comment, Class<?> type, Configuration configuration) {
        if (type == String.class) {
            return configuration.get(category, key, (String)defaultValue, comment);
        }
        if (type == Boolean.TYPE) {
            return configuration.get(category, key, ((Boolean)defaultValue).booleanValue(), comment);
        }
        if (type == Integer.TYPE) {
            return configuration.get(category, key, ((Integer)defaultValue).intValue(), comment);
        }
        if (type == Double.TYPE) {
            return configuration.get(category, key, ((Double)defaultValue).doubleValue(), comment);
        }
        if (type == List.class) {
            return ConfigRegistryFactory.getListProperty(category, key, defaultValue, comment, type, configuration);
        }
        throw new RuntimeException("Type not supported: " + type);
    }

    public static Configuration getOrCreateConfig(ConfigRegistry annotation, RebornRegistry rebornRegistry) {
        return ConfigRegistryFactory.getOrCreateConfig(rebornRegistry.modID(), annotation.config());
    }

    private static Configuration getOrCreateConfig(String modId, String config) {
        Configuration configuration;
        String configIdent = modId;
        if (!config.isEmpty()) {
            configIdent = configIdent + ":" + config;
        }
        if (configMap.containsKey(configIdent)) {
            configuration = configMap.get(configIdent);
        } else {
            File modConfigDir = new File(configDir, modId);
            String configName = "config.cfg";
            if (!config.isEmpty()) {
                configName = config + ".cfg";
            }
            configuration = new Configuration(new File(modConfigDir, configName));
            configMap.put(configIdent, configuration);
        }
        return configuration;
    }

    public static List<Pair<Configuration, String>> getConfigs(String modid) {
        return configMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(modid)).map(entry -> Pair.of(entry.getValue(), entry.getKey())).collect(Collectors.toList());
    }

    public static void saveAll() {
        for (Map.Entry<String, Configuration> configurationEntry : configMap.entrySet()) {
            configurationEntry.getValue().save();
        }
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)configVersionTag, (File)new File(configDir, "configData.nbt"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config data", e);
        }
    }

    @SubscribeEvent
    public static void onChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        List<Pair<Configuration, String>> configs = ConfigRegistryFactory.getConfigs(event.getModID());
        if (configs.isEmpty()) {
            return;
        }
        configs.forEach(pair -> ConfigRegistryFactory.reload((Configuration)pair.getLeft()));
    }

    public static void reload(Configuration configuration) {
        if (!configDataMap.containsKey(configuration)) {
            return;
        }
        ConfigData data = configDataMap.get(configuration);
        for (String category : configuration.getCategoryNames()) {
            for (Property property : configuration.getCategory(category).values()) {
                Field field = data.fieldMap.get(data.getName(category, property));
                if (field == null) {
                    RebornCore.logHelper.debug("failed to find field for " + property.getName());
                    continue;
                }
                try {
                    field.set(null, ConfigRegistryFactory.getObjectFromProperty(property, field));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        configuration.save();
    }

    public static void setConfigDir(File configDir) {
        ConfigRegistryFactory.configDir = configDir;
        File dataFile = new File(configDir, "configData.nbt");
        if (dataFile.exists()) {
            try {
                configVersionTag = CompressedStreamTools.func_74797_a((File)dataFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                RebornCore.logHelper.error("Failed to read config data, resetting.");
                RebornCore.logHelper.error(e);
                dataFile.delete();
                configVersionTag = new NBTTagCompound();
            }
        } else {
            configVersionTag = new NBTTagCompound();
        }
    }

    public boolean shouldReset(Property property, ConfigRegistry configRegistry, String modID) {
        NBTTagCompound propertyTag = configVersionTag.func_74775_l(this.getPropertyString(configRegistry, modID));
        propertyTag.func_74768_a("version", 0);
        propertyTag.func_74778_a("comment", configRegistry.comment());
        propertyTag.func_74778_a("key", configRegistry.key());
        propertyTag.func_74778_a("config", configRegistry.config());
        String configValue = property.getString();
        String savedDefault = propertyTag.func_74779_i("default");
        boolean shouldReset = false;
        if (configValue.equals(savedDefault) && !configValue.equals(property.getDefault())) {
            RebornCore.logHelper.info(configRegistry.key() + " is being reset to new mod default:" + property.getDefault());
            shouldReset = true;
        } else {
            propertyTag.func_74778_a("default", property.getDefault());
        }
        configVersionTag.func_74782_a(this.getPropertyString(configRegistry, modID), (NBTBase)propertyTag);
        return shouldReset;
    }

    private String getPropertyString(ConfigRegistry configRegistry, String modid) {
        return modid + "." + configRegistry.config() + "." + configRegistry.category() + "." + configRegistry.key();
    }

    @Override
    public List<RegistryTarget> getTargets() {
        return Collections.singletonList(RegistryTarget.FIELD);
    }

    @Override
    public Class<? extends FMLStateEvent> getProcessSate() {
        return RegistryConstructionEvent.class;
    }

    private static List getList(Property property, Field field) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Class listClass = (Class)genericType.getActualTypeArguments()[0];
        if (listClass == String.class) {
            return Arrays.asList(property.getStringList());
        }
        if (listClass == ItemStack.class) {
            List stacks = Arrays.stream(property.getStringList()).map(s -> (ItemStack)SerializationUtil.GSON_FLAT.fromJson(s, ItemStack.class)).collect(Collectors.toList());
            return stacks;
        }
        throw new UnsupportedOperationException("List type " + listClass.getName() + " not supported");
    }

    private static Property getListProperty(String category, String key, Object defaultValue, String comment, Class<?> type, Configuration configuration) {
        List defaultList = (List)defaultValue;
        if (defaultList.isEmpty()) {
            return configuration.get(category, key, new String[0], comment);
        }
        if (defaultList.get(0) instanceof ItemStack) {
            String[] stackList = (String[])defaultList.stream().map(o -> {
                ItemStack itemStack = (ItemStack)o;
                return SerializationUtil.GSON_FLAT.toJson((Object)itemStack);
            }).toArray(String[]::new);
            return configuration.get(category, key, stackList, comment);
        }
        throw new UnsupportedOperationException("List type " + defaultList.get(0).getClass().getName() + " not supported");
    }

    public class RebornRegistryEvent
    extends Event {
        public Configuration getConfiguration(String modid, String config) {
            return ConfigRegistryFactory.getOrCreateConfig(modid, config);
        }
    }

    private static class ConfigData {
        Configuration configuration;
        Map<String, Field> fieldMap;

        public ConfigData(Configuration configuration) {
            this.configuration = configuration;
            this.fieldMap = new HashMap<String, Field>();
        }

        public String getName(String category, Property property) {
            return category + ":" + property.getName();
        }
    }
}

