/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import reborncore.common.registration.impl.ConfigRegistryFactory;

public abstract class ConfigGuiFactory
implements IModGuiFactory {
    public abstract String getModID();

    public abstract String getModName();

    public void initialize(Minecraft minecraftInstance) {
    }

    public boolean hasConfigGui() {
        return true;
    }

    public GuiScreen createConfigGui(GuiScreen parentScreen) {
        return new ConfigGui(parentScreen, this.getModID(), this.getModName());
    }

    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return Collections.emptySet();
    }

    public static class ConfigGui
    extends GuiConfig {
        public ConfigGui(GuiScreen parentScreen, String modid, String modName) {
            super(parentScreen, ConfigGui.getElemets(modid), modid, modName, false, false, modName + " Configuration");
        }

        public static List<IConfigElement> getElemets(String modid) {
            return ConfigRegistryFactory.getConfigs(modid).stream().map(pair -> new DummyConfigElement.DummyCategoryElement((String)pair.getRight(), (String)pair.getRight(), ConfigGui.getChildren((Configuration)pair.getLeft()))).collect(Collectors.toList());
        }

        public static List<IConfigElement> getChildren(Configuration configuration) {
            ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
            for (final String categoryName : configuration.getCategoryNames()) {
                ConfigCategory category = configuration.getCategory(categoryName);
                for (Property property : category.values()) {
                    elements.add((IConfigElement)new ConfigElement(property){

                        public String getName() {
                            return categoryName + "." + super.getName();
                        }
                    });
                }
            }
            return elements;
        }
    }
}

