/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot.elements;

import java.awt.Color;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import reborncore.RebornCore;
import reborncore.client.gui.GuiUtil;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.elements.CheckBoxElement;
import reborncore.client.gui.builder.slot.elements.ConfigFluidElement;
import reborncore.client.gui.builder.slot.elements.ElementBase;
import reborncore.client.gui.builder.slot.elements.Sprite;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.packet.PacketFluidConfigSave;
import reborncore.common.network.packet.PacketFluidIOSave;
import reborncore.common.tile.FluidConfiguration;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.MachineFacing;

public class FluidConfigPopupElement
extends ElementBase {
    public boolean filter = false;
    ConfigFluidElement fluidElement;
    int lastMousex;
    int lastMousey;

    public FluidConfigPopupElement(int x, int y, ConfigFluidElement fluidElement) {
        super(x, y, Sprite.SLOT_CONFIG_POPUP);
        this.fluidElement = fluidElement;
    }

    @Override
    public void draw(GuiBase gui) {
        this.drawDefaultBackground((GuiScreen)gui, this.adjustX(gui, this.getX() - 8), this.adjustY(gui, this.getY() - 7), 84, 105 + (this.filter ? 15 : 0));
        super.draw(gui);
        TileLegacyMachineBase machine = (TileLegacyMachineBase)gui.tile;
        World blockAccess = machine.func_145831_w();
        BlockPos pos = machine.func_174877_v();
        IBlockState state = blockAccess.func_180495_p(pos);
        IBlockState actualState = state.func_177230_c().func_176223_P().func_185899_b((IBlockAccess)blockAccess, pos);
        BlockRendererDispatcher dispatcher = FMLClientHandler.instance().getClient().func_175602_ab();
        IBakedModel model = dispatcher.func_175023_a().func_178125_b(state.func_177230_c().func_176223_P());
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.drawState(gui, (IBlockAccess)blockAccess, model, actualState, pos, dispatcher, 4, 23);
        this.drawState(gui, (IBlockAccess)blockAccess, model, actualState, pos, dispatcher, 23, -12, -90.0f, 1.0f, 0.0f, 0.0f);
        this.drawState(gui, (IBlockAccess)blockAccess, model, actualState, pos, dispatcher, 23, 23, -90.0f, 0.0f, 1.0f, 0.0f);
        this.drawState(gui, (IBlockAccess)blockAccess, model, actualState, pos, dispatcher, 23, 42, 90.0f, 1.0f, 0.0f, 0.0f);
        this.drawState(gui, (IBlockAccess)blockAccess, model, actualState, pos, dispatcher, 26, 23, 180.0f, 0.0f, 1.0f, 0.0f);
        this.drawState(gui, (IBlockAccess)blockAccess, model, actualState, pos, dispatcher, 26, 42, 90.0f, 0.0f, 1.0f, 0.0f);
        this.drawSateColor(gui.getMachine(), MachineFacing.UP.getFacing(machine), 22, -1, gui);
        this.drawSateColor(gui.getMachine(), MachineFacing.FRONT.getFacing(machine), 22, 18, gui);
        this.drawSateColor(gui.getMachine(), MachineFacing.DOWN.getFacing(machine), 22, 37, gui);
        this.drawSateColor(gui.getMachine(), MachineFacing.RIGHT.getFacing(machine), 41, 18, gui);
        this.drawSateColor(gui.getMachine(), MachineFacing.BACK.getFacing(machine), 41, 37, gui);
        this.drawSateColor(gui.getMachine(), MachineFacing.LEFT.getFacing(machine), 3, 18, gui);
    }

    @Override
    public boolean onRelease(TileLegacyMachineBase provider, GuiBase gui, int mouseX, int mouseY) {
        if (this.isInBox(23, 4, 16, 16, mouseX, mouseY, gui)) {
            this.cyleConfig(MachineFacing.UP.getFacing(provider), gui);
        } else if (this.isInBox(23, 23, 16, 16, mouseX, mouseY, gui)) {
            this.cyleConfig(MachineFacing.FRONT.getFacing(provider), gui);
        } else if (this.isInBox(42, 23, 16, 16, mouseX, mouseY, gui)) {
            this.cyleConfig(MachineFacing.RIGHT.getFacing(provider), gui);
        } else if (this.isInBox(4, 23, 16, 16, mouseX, mouseY, gui)) {
            this.cyleConfig(MachineFacing.LEFT.getFacing(provider), gui);
        } else if (this.isInBox(23, 42, 16, 16, mouseX, mouseY, gui)) {
            this.cyleConfig(MachineFacing.DOWN.getFacing(provider), gui);
        } else if (this.isInBox(42, 42, 16, 16, mouseX, mouseY, gui)) {
            this.cyleConfig(MachineFacing.BACK.getFacing(provider), gui);
        } else {
            return false;
        }
        return true;
    }

    public void cyleConfig(EnumFacing side, GuiBase guiBase) {
        FluidConfiguration.FluidConfig config = guiBase.getMachine().fluidConfiguration.getSideDetail(side);
        FluidConfiguration.ExtractConfig fluidIO = config.getIoConfig().getNext();
        FluidConfiguration.FluidConfig newConfig = new FluidConfiguration.FluidConfig(side, fluidIO);
        PacketFluidConfigSave packetSave = new PacketFluidConfigSave(guiBase.tile.func_174877_v(), newConfig);
        NetworkManager.sendToServer(packetSave);
    }

    public void updateCheckBox(CheckBoxElement checkBoxElement, String type, GuiBase guiBase) {
        FluidConfiguration configHolder = guiBase.getMachine().fluidConfiguration;
        boolean input = configHolder.autoInput();
        boolean output = configHolder.autoOutput();
        if (type.equalsIgnoreCase("input")) {
            boolean bl = input = !configHolder.autoInput();
        }
        if (type.equalsIgnoreCase("output")) {
            output = !configHolder.autoOutput();
        }
        PacketFluidIOSave packetFluidIOSave = new PacketFluidIOSave(guiBase.tile.func_174877_v(), input, output);
        NetworkManager.sendToServer(packetFluidIOSave);
    }

    @Override
    public boolean onHover(TileLegacyMachineBase provider, GuiBase gui, int mouseX, int mouseY) {
        this.lastMousex = mouseX;
        this.lastMousey = mouseY;
        return super.onHover(provider, gui, mouseX, mouseY);
    }

    private void drawSateColor(TileLegacyMachineBase machineBase, EnumFacing side, int inx, int iny, GuiBase gui) {
        Color color;
        int sx = inx + this.getX() + gui.field_147003_i;
        int sy = (iny += 4) + this.getY() + gui.field_147009_r;
        FluidConfiguration fluidConfiguration = machineBase.fluidConfiguration;
        if (fluidConfiguration == null) {
            RebornCore.logHelper.debug("Humm, this isnt suppoed to happen");
            return;
        }
        FluidConfiguration.FluidConfig fluidConfig = fluidConfiguration.getSideDetail(side);
        switch (fluidConfig.getIoConfig()) {
            case NONE: {
                color = new Color(0, 0, 0, 0);
                break;
            }
            case INPUT: {
                color = new Color(0, 0, 255, 128);
                break;
            }
            case OUTPUT: {
                color = new Color(255, 69, 0, 128);
                break;
            }
            case ALL: {
                color = new Color(52, 255, 30, 128);
                break;
            }
            default: {
                color = new Color(0, 0, 0, 0);
            }
        }
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        GuiUtil.drawGradientRect(sx, sy, 18, 18, color.getRGB(), color.getRGB());
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
    }

    private boolean isInBox(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY, GuiBase guiBase) {
        return this.isInRect(guiBase, rectX += this.getX(), rectY += this.getY(), rectWidth, rectHeight, pointX, pointY);
    }

    public void drawState(GuiBase gui, IBlockAccess blockAccess, IBakedModel model, IBlockState actualState, BlockPos pos, BlockRendererDispatcher dispatcher, int x, int y, float rotAngle, float rotX, float rotY, float rotZ) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)(8 + gui.field_147003_i + this.x + x), (float)(8 + gui.field_147009_r + this.y + y), (float)512.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
        if (rotAngle != 0.0f) {
            GlStateManager.func_179114_b((float)rotAngle, (float)rotX, (float)rotY, (float)rotZ);
        }
        dispatcher.func_175019_b().func_178266_a(model, actualState, 1.0f, false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
    }

    public void drawState(GuiBase gui, IBlockAccess blockAccess, IBakedModel model, IBlockState actualState, BlockPos pos, BlockRendererDispatcher dispatcher, int x, int y) {
        this.drawState(gui, blockAccess, model, actualState, pos, dispatcher, x, y, 0.0f, 0.0f, 0.0f, 0.0f);
    }
}

