/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.utils.modulehelpers;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.machinemuse.powersuits.block.TileEntityPortal;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class DimensionalRiftHelper
extends Teleporter {
    private final WorldServer worldServerInstance;
    private final Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = new Long2ObjectOpenHashMap();

    public DimensionalRiftHelper(WorldServer par1WorldServer) {
        super(par1WorldServer);
        this.worldServerInstance = par1WorldServer;
    }

    public void func_180266_a(Entity entityIn, float rotationYaw) {
        if (!this.func_180620_b(entityIn, rotationYaw)) {
            if (this.worldServerInstance.field_73011_w.func_186058_p().func_186068_a() != -1) {
                BlockPos otherpos = this.worldServerInstance.func_175672_r(new BlockPos(entityIn).func_177982_a(0, -1, 0));
                entityIn.func_70012_b((double)otherpos.func_177958_n(), (double)otherpos.func_177956_o(), (double)otherpos.func_177952_p(), rotationYaw, 0.0f);
            } else {
                this.func_85188_a(entityIn);
            }
        }
    }

    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        int x = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int y = MathHelper.func_76128_c((double)entityIn.field_70163_u) - 1;
        int z = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        TileEntity destPortal = null;
        for (int s = 0; s <= 5 && destPortal == null; ++s) {
            for (int dx = -s; dx <= s; ++dx) {
                for (int dz = -s; dz <= s; ++dz) {
                    if (destPortal != null) continue;
                    destPortal = this.findPortalInChunk(new BlockPos(x + dx * 16, y, z + dz * 16));
                }
            }
        }
        if (destPortal != null) {
            entityIn.func_70012_b((double)destPortal.func_174877_v().func_177958_n() + 0.5, (double)(destPortal.func_174877_v().func_177956_o() + 1), (double)destPortal.func_174877_v().func_177952_p() + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
            entityIn.field_70179_y = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70159_w = 0.0;
            return true;
        }
        return false;
    }

    public TileEntity findPortalInChunk(BlockPos pos) {
        Chunk chunk = this.worldServerInstance.func_175726_f(pos);
        for (Object tile : chunk.func_177434_r().values()) {
            if (!(tile instanceof TileEntityPortal)) continue;
            return (TileEntity)tile;
        }
        return null;
    }

    public boolean func_85188_a(Entity entity) {
        int ex = MathHelper.func_76128_c((double)entity.field_70165_t);
        int ey = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
        int ez = MathHelper.func_76128_c((double)entity.field_70161_v);
        ey /= 5;
        if ((ey += 22) > 247) {
            ey = 247;
        }
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = -2; y <= 4; ++y) {
                    if (x == 0 && y == -1 && z == 0) continue;
                    if (y <= -2) {
                        this.worldServerInstance.func_175656_a(new BlockPos(ex + x, ey + y, ez + z), Blocks.field_150348_b.func_176223_P());
                        continue;
                    }
                    if (y == 0 && (x == 2 || x == -2 || z == 2 || z == -2)) continue;
                    this.worldServerInstance.func_175656_a(new BlockPos(ex + x, ey + y, ez + z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        entity.func_70012_b((double)ex + 0.5, (double)ey, (double)ez + 0.5, entity.field_70177_z, 0.0f);
        entity.field_70179_y = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70159_w = 0.0;
        return true;
    }

    public void func_85189_a(long worldTime) {
        if (worldTime % 100L == 0L) {
            long i = worldTime - 300L;
            ObjectIterator objectiterator = this.destinationCoordinateCache.values().iterator();
            while (objectiterator.hasNext()) {
                Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)objectiterator.next();
                if (portalposition != null && portalposition.field_85087_d >= i) continue;
                objectiterator.remove();
            }
        }
    }
}

