/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.config.NuminaConfig;
import net.machinemuse.numina.energy.ElectricItemUtils;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.math.MuseMathUtils;
import net.machinemuse.numina.nbt.MuseNBTUtils;
import net.machinemuse.numina.player.NuminaPlayerUtils;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.control.PlayerMovementInputWrapper;
import net.machinemuse.powersuits.item.armor.ItemPowerArmor;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MovementManager {
    static final double root2 = Math.sqrt(2.0);
    public static final Map<UUID, Double> playerJumpMultipliers = new HashMap<UUID, Double>();
    public static final double DEFAULT_GRAVITY = -0.0784000015258789;

    public static double getPlayerJumpMultiplier(EntityPlayer player) {
        if (playerJumpMultipliers.containsKey(player.func_174793_f().func_110124_au())) {
            return playerJumpMultipliers.get(player.func_174793_f().func_110124_au());
        }
        return 0.0;
    }

    public static void setPlayerJumpTicks(EntityPlayer player, double number) {
        playerJumpMultipliers.put(player.func_174793_f().func_110124_au(), number);
    }

    public static double computeFallHeightFromVelocity(double velocity) {
        double ticks = velocity / -0.0784000015258789;
        return 0.03920000076293945 * ticks * ticks;
    }

    public static void setMovementModifier(ItemStack itemStack, double multiplier, EntityPlayer player) {
        if (ModuleManager.INSTANCE.itemHasActiveModule(itemStack, "kineticGenerator")) {
            double movementResistance = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "movementResistance");
            multiplier -= movementResistance;
        }
        double additive = multiplier * (player.func_70051_ag() ? 0.13 : 0.1) / 2.0;
        NBTTagCompound itemNBT = MuseNBTUtils.getNBTTag((ItemStack)itemStack);
        boolean hasAttribute = false;
        if (itemNBT.func_150297_b("AttributeModifiers", 9)) {
            NBTTagList nbttaglist = itemNBT.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound attributeTag = nbttaglist.func_150305_b(i);
                if (!attributeTag.func_74779_i("Name").equals(SharedMonsterAttributes.field_111263_d.func_111108_a())) continue;
                attributeTag.func_74780_a("Amount", additive);
                hasAttribute = true;
                break;
            }
        }
        if (!hasAttribute && additive != 0.0) {
            itemStack.func_185129_a(SharedMonsterAttributes.field_111263_d.func_111108_a(), new AttributeModifier(SharedMonsterAttributes.field_111263_d.func_111108_a(), additive, 0), EntityEquipmentSlot.LEGS);
        }
    }

    public static double thrust(EntityPlayer player, double thrust, boolean flightControl) {
        PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get(player);
        double thrustUsed = 0.0;
        if (flightControl) {
            Vec3d desiredDirection = player.func_70040_Z().func_72432_b();
            double strafeX = desiredDirection.field_72449_c;
            double strafeZ = -desiredDirection.field_72450_a;
            double flightVerticality = 0.0;
            ItemStack helm = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!helm.func_190926_b() && helm.func_77973_b() instanceof IModularItem) {
                flightVerticality = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(helm, "yLookRatio");
            }
            desiredDirection = new Vec3d(desiredDirection.field_72450_a * (double)Math.signum(playerInput.moveForward) + strafeX * (double)Math.signum(playerInput.moveStrafe), flightVerticality * desiredDirection.field_72448_b * (double)Math.signum(playerInput.moveForward) + (double)(playerInput.jumpKey ? 1 : 0) - (double)(playerInput.downKey ? 1 : 0), desiredDirection.field_72449_c * (double)Math.signum(playerInput.moveForward) + strafeZ * (double)Math.signum(playerInput.moveStrafe));
            desiredDirection = desiredDirection.func_72432_b();
            if (player.field_70181_x < 0.0 && desiredDirection.field_72448_b >= 0.0) {
                if (-player.field_70181_x > thrust) {
                    player.field_70181_x += thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= player.field_70181_x;
                    thrustUsed += player.field_70181_x;
                    player.field_70181_x = 0.0;
                }
            }
            if (player.field_70181_x < -1.0) {
                thrust += 1.0 + player.field_70181_x;
                thrustUsed -= 1.0 + player.field_70181_x;
                player.field_70181_x = -1.0;
            }
            if (Math.abs(player.field_70159_w) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.field_70159_w) > thrust) {
                    player.field_70159_w -= Math.signum(player.field_70159_w) * thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= Math.abs(player.field_70159_w);
                    thrustUsed += Math.abs(player.field_70159_w);
                    player.field_70159_w = 0.0;
                }
            }
            if (Math.abs(player.field_70179_y) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.field_70179_y) > thrust) {
                    player.field_70179_y -= Math.signum(player.field_70179_y) * thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrustUsed += Math.abs(player.field_70179_y);
                    thrust -= Math.abs(player.field_70179_y);
                    player.field_70179_y = 0.0;
                }
            }
            player.field_70159_w += thrust * desiredDirection.field_72450_a;
            player.field_70181_x += thrust * desiredDirection.field_72448_b;
            player.field_70179_y += thrust * desiredDirection.field_72449_c;
            thrustUsed += thrust;
        } else {
            Vec3d playerHorzFacing = player.func_70040_Z();
            playerHorzFacing = new Vec3d(playerHorzFacing.field_72450_a, 0.0, playerHorzFacing.field_72449_c);
            playerHorzFacing.func_72432_b();
            if (playerInput.moveForward == 0.0f) {
                player.field_70181_x += thrust;
            } else {
                player.field_70181_x += thrust / root2;
                player.field_70159_w += playerHorzFacing.field_72450_a * thrust / root2 * (double)Math.signum(playerInput.moveForward);
                player.field_70179_y += playerHorzFacing.field_72449_c * thrust / root2 * (double)Math.signum(playerInput.moveForward);
            }
            thrustUsed += thrust;
        }
        double horzm2 = player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y;
        double horizontalLimit = MPSConfig.INSTANCE.getMaximumFlyingSpeedmps() * MPSConfig.INSTANCE.getMaximumFlyingSpeedmps() / 400.0;
        if (playerInput.sneakKey && horizontalLimit > 0.05) {
            horizontalLimit = 0.05;
        }
        if (horzm2 > horizontalLimit) {
            double ratio = Math.sqrt(horizontalLimit / horzm2);
            player.field_70159_w *= ratio;
            player.field_70179_y *= ratio;
        }
        NuminaPlayerUtils.resetFloatKickTicks((EntityPlayer)player);
        return thrustUsed;
    }

    public static double computePlayerVelocity(EntityPlayer entityPlayer) {
        return MuseMathUtils.pythag((double)entityPlayer.field_70159_w, (double)entityPlayer.field_70181_x, (double)entityPlayer.field_70179_y);
    }

    @SubscribeEvent
    public void handleLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.getEntityLiving() instanceof EntityPlayer && !(stack = (player = (EntityPlayer)event.getEntityLiving()).func_184582_a(EntityEquipmentSlot.LEGS)).func_190926_b() && stack.func_77973_b() instanceof ItemPowerArmor && ModuleManager.INSTANCE.itemHasActiveModule(stack, "jumpAssist")) {
            double jumpAssist = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "jumpBoost") * 2.0;
            double drain = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "jumpEnergyCon");
            int avail = ElectricItemUtils.getPlayerEnergy((EntityPlayer)player);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                Musique.playerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JUMP_ASSIST, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(jumpAssist / 8.0)), (Float)Float.valueOf(1.0f), (Boolean)false);
            }
            if (drain < (double)avail) {
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)drain));
                MovementManager.setPlayerJumpTicks(player, jumpAssist);
                double jumpCompensationRatio = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "jumpExhaustComp");
                if (player.func_70051_ag()) {
                    player.func_71024_bL().func_75113_a((float)((double)-0.2f * jumpCompensationRatio));
                } else {
                    player.func_71024_bL().func_75113_a((float)((double)-0.05f * jumpCompensationRatio));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        ItemStack boots;
        if (event.getEntityLiving() instanceof EntityPlayer && (double)event.getDistance() > 3.0 && !(boots = (player = (EntityPlayer)event.getEntityLiving()).func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && ModuleManager.INSTANCE.itemHasActiveModule(boots, "shockAbsorber")) {
            int avail;
            double drain;
            double distanceAbsorb = (double)event.getDistance() * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(boots, "distanceRed");
            if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.playerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_GUI_INSTALL, (SoundCategory)SoundCategory.PLAYERS, (float)((float)distanceAbsorb), (Float)Float.valueOf(1.0f), (Boolean)false);
            }
            if ((drain = distanceAbsorb * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(boots, "impactEnergyCon")) < (double)(avail = ElectricItemUtils.getPlayerEnergy((EntityPlayer)player))) {
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)drain));
                event.setDistance((float)((double)event.getDistance() - distanceAbsorb));
            }
        }
    }
}

