/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.blocks.item.MixedBlockBlockItem;
import net.malisis.blocks.renderer.MixedBlockRenderer;
import net.malisis.blocks.tileentity.MixedBlockTileEntity;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisRendered(value=MixedBlockRenderer.class)
public class MixedBlock
extends MalisisBlock
implements ITileEntityProvider {
    public MixedBlock() {
        super(Material.field_151576_e);
        this.setName("mixed_block");
        this.func_149711_c(0.7f);
        this.addComponent((IComponent)new DirectionalComponent(DirectionalComponent.ALL));
    }

    public Item getItem(Block block) {
        return new MixedBlockBlockItem(this);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        MixedBlockTileEntity te = (MixedBlockTileEntity)((Object)TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return;
        }
        te.set(itemStack);
        world.func_175664_x(pos);
        world.func_175685_c(pos, (Block)this, false);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        MixedBlockTileEntity te = (MixedBlockTileEntity)((Object)TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return null;
        }
        return MixedBlockBlockItem.fromTileEntity(te);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        MixedBlockTileEntity te = (MixedBlockTileEntity)((Object)TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null || te.getState1() == null || te.getState2() == null) {
            return 0;
        }
        return Math.max(te.getState1().func_185906_d(), te.getState2().func_185906_d());
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        MixedBlockTileEntity te = (MixedBlockTileEntity)((Object)TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null || te.getState1() == null || te.getState2() == null) {
            return 0;
        }
        return te.getState1().func_177230_c() == Blocks.field_150451_bX || te.getState2().func_177230_c() == Blocks.field_150451_bX ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_175625_s(target.func_178782_a());
        if (te == null || te.getState1() == null || te.getState2() == null) {
            return true;
        }
        EntityUtils.addHitEffects((World)world, (RayTraceResult)target, (ParticleManager)manager, (IBlockState[])new IBlockState[]{te.getState1(), te.getState2()});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_175625_s(pos);
        if (te == null || te.getState1() == null || te.getState2() == null) {
            return true;
        }
        EntityUtils.addDestroyEffects((World)world, (BlockPos)pos, (ParticleManager)manager, (IBlockState[])new IBlockState[]{te.getState1(), te.getState2()});
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new MixedBlockTileEntity();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        MixedBlockTileEntity te;
        if (!player.field_71075_bZ.field_75098_d && (te = (MixedBlockTileEntity)((Object)TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, (BlockPos)pos))) != null) {
            MixedBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)MixedBlockBlockItem.fromTileEntity(te));
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState neighborState = world.func_180495_p(pos.func_177972_a(side));
        if (neighborState.func_185904_a() == Material.field_151579_a) {
            return true;
        }
        if (neighborState.func_177230_c() != this && !(neighborState.func_177230_c() instanceof BlockBreakable)) {
            return !neighborState.func_185914_p();
        }
        MixedBlockTileEntity current = (MixedBlockTileEntity)((Object)TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        return current != null && !MixedBlock.isOpaque(world, pos) && current.isOpaque();
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return MixedBlock.isOpaque(world, pos);
    }

    public static boolean isOpaque(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockBreakable) {
            return true;
        }
        MixedBlockTileEntity te = (MixedBlockTileEntity)((Object)TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        return te != null && te.isOpaque();
    }
}

