/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.containers.ContainerCargo;
import vswe.stevescarts.guis.GuiManager;
import vswe.stevescarts.helpers.CargoItemSelection;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

@SideOnly(value=Side.CLIENT)
public class GuiCargo
extends GuiManager {
    private static ResourceLocation[] texturesLeft = new ResourceLocation[]{ResourceHelper.getResource("/gui/cargoVersion0Part1.png"), ResourceHelper.getResource("/gui/cargoVersion1Part1.png")};
    private static ResourceLocation[] texturesRight = new ResourceLocation[]{ResourceHelper.getResource("/gui/cargoVersion0Part2.png"), ResourceHelper.getResource("/gui/cargoVersion1Part2.png")};

    public GuiCargo(InventoryPlayer invPlayer, TileEntityCargo cargo) {
        super(cargo, new ContainerCargo((IInventory)invPlayer, cargo));
        this.setXSize(305);
        this.setYSize(222);
    }

    @Override
    protected String getMaxSizeOverlay(int id) {
        int amount = this.getCargo().getAmount(id);
        int type = this.getCargo().getAmountType(id);
        if (type == 0) {
            return Localization.GUI.CARGO.TRANSFER_ALL.translate(new String[0]);
        }
        if (type == 1) {
            return Localization.GUI.CARGO.TRANSFER_ITEMS.translate(String.valueOf(amount), String.valueOf(amount));
        }
        return Localization.GUI.CARGO.TRANSFER_STACKS.translate(String.valueOf(amount), String.valueOf(amount));
    }

    @Override
    protected String getMaxSizeText(int id) {
        String s;
        int type = this.getCargo().getAmountType(id);
        if (type == 0) {
            s = Localization.GUI.CARGO.TRANSFER_ALL_SHORT.translate(new String[0]);
        } else {
            int amount = this.getCargo().getAmount(id);
            s = String.valueOf(amount);
            s = type == 1 ? s + " " + Localization.GUI.CARGO.TRANSFER_ITEMS_SHORT.translate(new String[0]) : s + " " + Localization.GUI.CARGO.TRANSFER_STACKS_SHORT.translate(new String[0]);
        }
        return s;
    }

    @Override
    protected void drawBackground(int left, int top) {
        int version = this.getManager().layoutType == 0 ? 0 : 1;
        ResourceHelper.bindResource(texturesLeft[version]);
        this.func_73729_b(left, top, 0, 0, 256, this.field_147000_g);
        ResourceHelper.bindResource(texturesRight[version]);
        this.func_73729_b(left + 256, top, 0, 0, this.field_146999_f - 256, this.field_147000_g);
    }

    @Override
    protected int getArrowSourceX() {
        return 49;
    }

    @Override
    protected int getColorSourceX() {
        return 105;
    }

    @Override
    protected int getCenterTargetX() {
        return 98;
    }

    @Override
    protected void drawColors(int id, int color, int left, int top) {
        super.drawColors(id, color, left, top);
        if (this.getManager().layoutType == 2) {
            int[] coords = this.getInvCoords(id);
            this.func_73729_b(left + coords[0] - 2, top + coords[1] - 2, 125, 56 * color, 92, 56);
        }
    }

    @Override
    protected void drawItems(int id, RenderItem renderitem, int left, int top) {
        ItemStack cartIcon = this.getCargo().target[id] < 0 || this.getCargo().target[id] >= TileEntityCargo.itemSelections.size() || TileEntityCargo.itemSelections.get(this.getCargo().target[id]).getIcon().func_190926_b() ? new ItemStack(Items.field_151143_au, 1) : TileEntityCargo.itemSelections.get(this.getCargo().target[id]).getIcon();
        int[] coords = this.getBoxCoords(id);
        RenderHelper.func_74520_c();
        renderitem.func_175042_a(cartIcon, left + coords[0], top + coords[1]);
        RenderHelper.func_74518_a();
    }

    @Override
    protected int offsetObjectY(int layout, int x, int y) {
        if (layout != 0) {
            return -5 + y * 10;
        }
        return super.offsetObjectY(layout, x, y);
    }

    @Override
    protected boolean sendOnClick(int id, int x, int y, byte data) {
        if (this.inRect(x, y, this.getBoxCoords(id))) {
            this.getManager().sendPacket(1, data);
            return true;
        }
        return false;
    }

    @Override
    protected void drawExtraOverlay(int id, int x, int y) {
        if (this.getCargo().target[id] >= 0) {
            int n = this.getCargo().target[id];
            this.getCargo();
            if (n < TileEntityCargo.itemSelections.size()) {
                this.getCargo();
                CargoItemSelection item = TileEntityCargo.itemSelections.get(this.getCargo().target[id]);
                if (item.getName() != null) {
                    this.drawMouseOver(Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + item.getName(), x, y, this.getBoxCoords(id));
                } else {
                    this.drawMouseOver(Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + Localization.GUI.CARGO.UNKNOWN_AREA.translate(new String[0]), x, y, this.getBoxCoords(id));
                }
                return;
            }
        }
        this.drawMouseOver(Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + Localization.GUI.CARGO.UNKNOWN_AREA.translate(new String[0]), x, y, this.getBoxCoords(id));
    }

    @Override
    protected Block getBlock() {
        return ModBlocks.CARGO_MANAGER.getBlock();
    }

    @Override
    protected String getManagerName() {
        return Localization.GUI.CARGO.TITLE.translate(new String[0]);
    }

    private int[] getInvCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = 8 + x * 198;
        int yCoord = 11 + y * 64;
        return new int[]{xCoord, yCoord};
    }

    private TileEntityCargo getCargo() {
        return (TileEntityCargo)this.getManager();
    }

    @Override
    protected String getLayoutString() {
        return Localization.GUI.CARGO.CHANGE_SLOT_LAYOUT.translate(new String[0]);
    }

    @Override
    protected String getLayoutOption(int id) {
        switch (id) {
            default: {
                return Localization.GUI.CARGO.LAYOUT_SHARED.translate(new String[0]);
            }
            case 1: {
                return Localization.GUI.CARGO.LAYOUT_SIDE.translate(new String[0]);
            }
            case 2: 
        }
        return Localization.GUI.CARGO.LAYOUT_COLOR.translate(new String[0]);
    }
}

