/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class SawmillParser
extends BaseParser {
    int defaultEnergy = 2000;
    Set<ItemStack> removeQueue = new ObjectOpenHashSet();

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            ItemStack output2 = ItemStack.field_190927_a;
            int energy = this.defaultEnergy;
            int chance = 100;
            ItemStack input = SawmillParser.parseItemStack(content.get("input"));
            if (content.has("remove") && content.get("remove").getAsBoolean()) {
                this.removeQueue.add(input);
                continue;
            }
            ItemStack output = SawmillParser.parseItemStack(content.get("output"));
            if (content.has("output2")) {
                JsonElement outputElement = content.get("output2");
                output2 = SawmillParser.parseItemStack(outputElement);
                chance = SawmillParser.getChance(outputElement);
            }
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (SawmillManager.addRecipe(energy, input, output, output2, chance) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }

    @Override
    public void postProcess() {
        for (ItemStack stack : this.removeQueue) {
            SawmillManager.removeRecipe(stack);
        }
    }
}

