/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.core.inventory.ComparableItemStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ReactantManager {
    private static Map<List<Integer>, Reaction> reactionMap = new Object2ObjectOpenHashMap();
    private static Set<ComparableItemStack> validReactants = new ObjectOpenHashSet();
    private static Set<String> validFluids = new ObjectOpenHashSet();
    private static Set<ComparableItemStack> validReactantsElemental = new ObjectOpenHashSet();
    private static Set<String> validFluidsElemental = new ObjectOpenHashSet();
    public static int DEFAULT_ENERGY = 100000;

    public static Reaction getReaction(ItemStack reactant, FluidStack fluid) {
        return reactant.func_190926_b() || fluid == null ? null : reactionMap.get(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.getFluid().getName().hashCode()));
    }

    public static Reaction getReaction(ItemStack reactant, Fluid fluid) {
        return reactant.func_190926_b() || fluid == null ? null : reactionMap.get(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.getName().hashCode()));
    }

    public static boolean reactionExists(ItemStack reactant, FluidStack fluid) {
        return ReactantManager.getReaction(reactant, fluid) != null;
    }

    public static boolean reactionExists(ItemStack reactant, Fluid fluid) {
        return ReactantManager.getReaction(reactant, fluid) != null;
    }

    public static boolean reactionExistsElemental(ItemStack reactant, Fluid fluid) {
        return ReactantManager.validReactantElemental(reactant) && ReactantManager.validFluidElemental(fluid);
    }

    public static Reaction[] getReactionList() {
        return reactionMap.values().toArray(new Reaction[reactionMap.size()]);
    }

    public static boolean validReactant(ItemStack reactant) {
        return !reactant.func_190926_b() && validReactants.contains(new ComparableItemStack(reactant));
    }

    public static boolean validReactantElemental(ItemStack reactant) {
        return !reactant.func_190926_b() && validReactantsElemental.contains(new ComparableItemStack(reactant));
    }

    public static boolean validFluid(FluidStack fluid) {
        return fluid != null && validFluids.contains(fluid.getFluid().getName());
    }

    public static boolean validFluidElemental(FluidStack fluid) {
        return fluid != null && validFluidsElemental.contains(fluid.getFluid().getName());
    }

    public static boolean validFluidElemental(Fluid fluid) {
        return fluid != null && validFluidsElemental.contains(fluid.getName());
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempReactionMap = new Object2ObjectOpenHashMap(reactionMap.size());
        ObjectOpenHashSet tempSet = new ObjectOpenHashSet();
        ObjectOpenHashSet tempSet2 = new ObjectOpenHashSet();
        for (Map.Entry<List<Integer>, Reaction> entry : reactionMap.entrySet()) {
            Reaction tempReaction = entry.getValue();
            ComparableItemStack reactant = new ComparableItemStack(tempReaction.reactant);
            tempReactionMap.put(Arrays.asList(reactant.hashCode(), tempReaction.getFluidName().hashCode()), tempReaction);
            tempSet.add(reactant);
            if (!validFluidsElemental.contains(tempReaction.getFluidName())) continue;
            tempSet2.add(reactant);
        }
        reactionMap.clear();
        reactionMap = tempReactionMap;
        validReactants.clear();
        validReactants = tempSet;
        validReactantsElemental.clear();
        validReactantsElemental = tempSet2;
    }

    public static boolean addReaction(ItemStack reactant, Fluid fluid, int energy) {
        if (reactant.func_190926_b() || fluid == null || energy < 10000 || energy > 200000000) {
            return false;
        }
        if (ReactantManager.reactionExists(reactant, fluid)) {
            return false;
        }
        Reaction reaction = new Reaction(reactant, fluid, energy);
        reactionMap.put(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.getName().hashCode()), reaction);
        validReactants.add(new ComparableItemStack(reactant));
        validFluids.add(fluid.getName());
        return true;
    }

    public static boolean addElementalReaction(ItemStack reactant, Fluid fluid, int energy) {
        if (ReactantManager.addReaction(reactant, fluid, energy)) {
            validReactantsElemental.add(new ComparableItemStack(reactant));
            validFluidsElemental.add(fluid.getName());
            return true;
        }
        return false;
    }

    public static boolean removeReaction(ItemStack reactant, Fluid fluid) {
        return reactionMap.remove(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.getName().hashCode())) != null;
    }

    public static boolean removeElementalReaction(ItemStack reactant, Fluid fluid) {
        validReactantsElemental.remove(new ComparableItemStack(reactant));
        validFluidsElemental.remove(fluid.getName());
        return true;
    }

    public static class Reaction {
        final ItemStack reactant;
        final Fluid fluid;
        final int energy;

        Reaction(ItemStack reactant, Fluid fluid, int energy) {
            this.reactant = reactant;
            this.fluid = fluid;
            this.energy = energy;
        }

        public ItemStack getReactant() {
            return this.reactant;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public String getFluidName() {
            return this.fluid.getName();
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

