/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoEnervation;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoEnervation;
import cofh.thermalexpansion.util.managers.dynamo.EnervationManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoEnervation
extends TileDynamoBase {
    protected static final EnergyConfig ENERGY_CONFIG = new EnergyConfig();
    protected static final HashSet<String> VALID_AUGMENTS = new HashSet();
    public static boolean enable = true;
    public static int basePower = 40;
    protected boolean augmentEnchant;

    public static void initialize() {
        VALID_AUGMENTS.addAll(VALID_AUGMENTS_BASE);
        VALID_AUGMENTS.add("dynamoEnervationEnchant");
        GameRegistry.registerTileEntity(TileDynamoEnervation.class, (String)"thermalexpansion:dynamo_enervation");
        TileDynamoEnervation.config();
    }

    public static void config() {
        String category = "Dynamo.Enervation";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for an Enervation Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 1000, comment);
        ENERGY_CONFIG.setDefaultParams(basePower, smallStorage);
    }

    public TileDynamoEnervation() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    protected String getTileName() {
        return "tile.thermalexpansion.dynamo.enervation.name";
    }

    @Override
    protected EnergyConfig getEnergyConfig() {
        return ENERGY_CONFIG;
    }

    @Override
    protected HashSet<String> getValidAugments() {
        return VALID_AUGMENTS;
    }

    @Override
    protected boolean canStart() {
        if (this.augmentEnchant) {
            return !EnchantmentHelper.func_82781_a((ItemStack)this.inventory[0]).isEmpty();
        }
        return EnervationManager.getFuelEnergy(this.inventory[0]) > 0;
    }

    @Override
    protected void processStart() {
        if (this.augmentEnchant) {
            this.maxFuelRF = EnervationManager.getEnchantEnergy(this.inventory[0]) * this.energyMod / 100;
            this.fuelRF += this.maxFuelRF;
            this.inventory[0] = ItemStack.field_190927_a;
        } else if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            IEnergyContainerItem container = (IEnergyContainerItem)this.inventory[0].func_77973_b();
            this.maxFuelRF = container.extractEnergy(this.inventory[0], container.getEnergyStored(this.inventory[0]), false);
            this.fuelRF += this.maxFuelRF;
        } else {
            this.maxFuelRF = EnervationManager.getFuelEnergy(this.inventory[0]) * this.energyMod / 100;
            this.fuelRF += this.maxFuelRF;
            this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)TFFluids.fluidRedstone.getStill());
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoEnervation(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoEnervation(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, EnervationManager.DEFAULT_ENERGY);
        } else if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            return scale;
        }
        return this.fuelRF * scale / this.maxFuelRF;
    }

    @Override
    public int getFuelEnergy(ItemStack stack) {
        return (this.augmentEnchant ? EnervationManager.getEnchantEnergy(stack) : EnervationManager.getFuelEnergy(stack)) * this.energyMod / 100;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxFuelRF = nbt.func_74762_e("FuelMax");
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, EnervationManager.DEFAULT_ENERGY);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.maxFuelRF);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.maxFuelRF);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.maxFuelRF = payload.getInt();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentEnchant = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentEnchant && "dynamoEnervationEnchant".equals(id)) {
            this.augmentEnchant = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 4 * this.getBasePower(this.level), smallStorage);
            this.energyMod += 25;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.augmentEnchant ? !EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty() : EnervationManager.getFuelEnergy(stack) > 0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == null || side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }
}

