/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.render.FontRendererCore;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.SecurityHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCore
extends Item {
    protected String name;
    protected String modName;

    public ItemCore() {
        this("cofh");
    }

    public ItemCore(String modName) {
        this.modName = modName;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return SecurityHelper.isSecure(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        if (this.isActive(stack)) {
            return "";
        }
        return displayName;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        if (SecurityHelper.isSecure(stack)) {
            location.field_83001_bt = true;
            location.field_70178_ae = true;
            ((EntityItem)location).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return FontRendererCore.loadFontRendererStack(stack);
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Active");
    }

    protected int getTintIndex(ItemStack stack) {
        return 2;
    }

    public int colorMultiplier(ItemStack stack, int tintIndex) {
        if (ColorHelper.hasColor0(stack) && tintIndex == this.getTintIndex(stack)) {
            return ColorHelper.getColor0(stack);
        }
        return 0xFFFFFF;
    }

    public void applyColor(ItemStack stack, int color, int colorIndex) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((colorIndex = Math.min(colorIndex, this.getMaxColorIndex(stack))) == 0) {
            stack.func_77978_p().func_74768_a("Color0", color);
        } else {
            stack.func_77978_p().func_74768_a("Color1", color);
        }
    }

    public void removeColor(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_82580_o("Color0");
        stack.func_77978_p().func_82580_o("Color1");
    }

    public int getMaxColorIndex(ItemStack stack) {
        return 0;
    }
}

