/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.audio.ISoundSource;
import cofh.core.audio.SoundTile;
import cofh.core.block.TileNameable;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCore;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.SoundHelper;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileRSControl
extends TileNameable
implements IRedstoneControl,
ISoundSource {
    public boolean isActive;
    public boolean wasActive;
    protected int powerLevel;
    protected boolean isPowered;
    protected boolean wasPowered;
    protected IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.DISABLED;

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        this.rsMode = RedstoneControlHelper.getControlFromNBT(tag);
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        RedstoneControlHelper.setItemStackTagRS(tag, this);
        return true;
    }

    @Override
    public void blockPlaced() {
        this.onNeighborBlockChange();
    }

    @Override
    public void onNeighborBlockChange() {
        this.wasPowered = this.isPowered;
        this.powerLevel = this.field_145850_b.func_175687_A(this.field_174879_c);
        boolean bl = this.isPowered = this.powerLevel > 0;
        if (this.wasPowered != this.isPowered && this.sendRedstoneUpdates()) {
            PacketCore.sendRSPowerUpdatePacketToClients(this, this.field_145850_b, this.field_174879_c);
            this.onRedstoneUpdate();
        }
    }

    public void onRedstoneUpdate() {
    }

    protected boolean sendRedstoneUpdates() {
        return false;
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isActive = nbt.func_74767_n("Active");
        NBTTagCompound rsTag = nbt.func_74775_l("RS");
        this.isPowered = rsTag.func_74767_n("Power");
        this.powerLevel = rsTag.func_74771_c("Level");
        this.rsMode = IRedstoneControl.ControlMode.values()[rsTag.func_74771_c("Mode")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Active", this.isActive);
        NBTTagCompound rsTag = new NBTTagCompound();
        rsTag.func_74757_a("Power", this.isPowered);
        rsTag.func_74774_a("Level", (byte)this.powerLevel);
        rsTag.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        nbt.func_74782_a("RS", (NBTBase)rsTag);
        return nbt;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addBool(this.isPowered);
        payload.addByte(this.rsMode.ordinal());
        payload.addBool(this.isActive);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.isPowered = payload.getBool();
        this.rsMode = IRedstoneControl.ControlMode.values()[payload.getByte()];
        boolean curActive = this.isActive;
        this.isActive = payload.getBool();
        if (!curActive && this.isActive && this.getSoundEvent() != null) {
            SoundHelper.playSound(this.getSound());
        }
    }

    @Override
    public final void setPowered(boolean isPowered) {
        this.wasPowered = this.isPowered;
        this.isPowered = isPowered;
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            this.callBlockUpdate();
        }
    }

    @Override
    public final boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public final boolean setControl(IRedstoneControl.ControlMode control) {
        this.rsMode = control;
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            PacketCore.sendRSConfigUpdatePacketToServer(this, this.field_174879_c);
        } else {
            this.onRedstoneUpdate();
        }
        return true;
    }

    @Override
    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundTile(this, this.getSoundEvent(), this.getVolume(), 1.0f, true, 0, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldPlaySound() {
        return !this.field_145846_f && this.isActive;
    }

    protected float getVolume() {
        return 1.0f;
    }

    protected SoundEvent getSoundEvent() {
        return null;
    }
}

