/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.cablebus.SmartCableTextures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

class CableBuilder {
    private final VertexFormat format;
    private final EnumMap<CableCoreType, EnumMap<AEColor, TextureAtlasSprite>> coreTextures;
    private final EnumMap<AECableType, EnumMap<AEColor, TextureAtlasSprite>> connectionTextures;
    private final SmartCableTextures smartCableTextures;

    CableBuilder(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        EnumMap<AEColor, TextureAtlasSprite> colorTextures;
        this.format = format;
        this.coreTextures = new EnumMap(CableCoreType.class);
        for (CableCoreType cableCoreType : CableCoreType.values()) {
            colorTextures = new EnumMap<AEColor, TextureAtlasSprite>(AEColor.class);
            for (AEColor color : AEColor.values()) {
                colorTextures.put(color, bakedTextureGetter.apply(cableCoreType.getTexture(color)));
            }
            this.coreTextures.put(cableCoreType, colorTextures);
        }
        this.connectionTextures = new EnumMap(AECableType.class);
        for (Enum enum_ : AECableType.VALIDCABLES) {
            colorTextures = new EnumMap(AEColor.class);
            for (AEColor color : AEColor.values()) {
                colorTextures.put(color, bakedTextureGetter.apply(CableBuilder.getConnectionTexture((AECableType)enum_, color)));
            }
            this.connectionTextures.put((AECableType)enum_, colorTextures);
        }
        this.smartCableTextures = new SmartCableTextures(bakedTextureGetter);
    }

    static ResourceLocation getConnectionTexture(AECableType cableType, AEColor color) {
        String textureFolder;
        switch (cableType) {
            case GLASS: {
                textureFolder = "parts/cable/glass/";
                break;
            }
            case COVERED: {
                textureFolder = "parts/cable/covered/";
                break;
            }
            case SMART: {
                textureFolder = "parts/cable/smart/";
                break;
            }
            case DENSE_COVERED: {
                textureFolder = "parts/cable/dense_covered/";
                break;
            }
            case DENSE_SMART: {
                textureFolder = "parts/cable/dense_smart/";
                break;
            }
            default: {
                throw new IllegalStateException("Cable type " + (Object)((Object)cableType) + " does not support connections.");
            }
        }
        return new ResourceLocation("appliedenergistics2", textureFolder + color.name().toLowerCase());
    }

    public void addCableCore(AECableType cableType, AEColor color, List<BakedQuad> quadsOut) {
        switch (cableType) {
            case GLASS: {
                this.addCableCore(CableCoreType.GLASS, color, quadsOut);
                break;
            }
            case COVERED: 
            case SMART: {
                this.addCableCore(CableCoreType.COVERED, color, quadsOut);
                break;
            }
            case DENSE_COVERED: 
            case DENSE_SMART: {
                this.addCableCore(CableCoreType.DENSE, color, quadsOut);
                break;
            }
        }
    }

    public void addCableCore(CableCoreType coreType, AEColor color, List<BakedQuad> quadsOut) {
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.coreTextures.get((Object)coreType).get((Object)color);
        cubeBuilder.setTexture(texture);
        switch (coreType) {
            case GLASS: {
                cubeBuilder.addCube(6.0f, 6.0f, 6.0f, 10.0f, 10.0f, 10.0f);
                break;
            }
            case COVERED: {
                cubeBuilder.addCube(5.0f, 5.0f, 5.0f, 11.0f, 11.0f, 11.0f);
                break;
            }
            case DENSE: {
                cubeBuilder.addCube(3.0f, 3.0f, 3.0f, 13.0f, 13.0f, 13.0f);
            }
        }
    }

    public void addGlassConnection(EnumFacing facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, List<BakedQuad> quadsOut) {
        TextureAtlasSprite texture;
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        if (connectionType != AECableType.GLASS && !cableBusAdjacent) {
            texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
            cubeBuilder.setTexture(texture);
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
        }
        texture = this.connectionTextures.get((Object)AECableType.GLASS).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        switch (facing) {
            case DOWN: {
                cubeBuilder.addCube(6.0f, 0.0f, 6.0f, 10.0f, 6.0f, 10.0f);
                break;
            }
            case EAST: {
                cubeBuilder.addCube(10.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                cubeBuilder.addCube(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 6.0f);
                break;
            }
            case SOUTH: {
                cubeBuilder.addCube(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                cubeBuilder.addCube(6.0f, 10.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                cubeBuilder.addCube(0.0f, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
            }
        }
    }

    public void addStraightGlassConnection(EnumFacing facing, AEColor cableColor, List<BakedQuad> quadsOut) {
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing, facing.func_176734_d())));
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.GLASS).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        switch (facing) {
            case DOWN: 
            case UP: {
                cubeBuilder.addCube(6.0f, 0.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case NORTH: 
            case SOUTH: {
                cubeBuilder.addCube(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case EAST: 
            case WEST: {
                cubeBuilder.addCube(0.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
            }
        }
    }

    public void addConstrainedGlassConnection(EnumFacing facing, AEColor cableColor, int distanceFromEdge, List<BakedQuad> quadsOut) {
        if (distanceFromEdge >= 6) {
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.GLASS).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        switch (facing) {
            case DOWN: {
                cubeBuilder.addCube(6.0f, distanceFromEdge, 6.0f, 10.0f, 6.0f, 10.0f);
                break;
            }
            case EAST: {
                cubeBuilder.addCube(10.0f, 6.0f, 6.0f, 16 - distanceFromEdge, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                cubeBuilder.addCube(6.0f, 6.0f, distanceFromEdge, 10.0f, 10.0f, 6.0f);
                break;
            }
            case SOUTH: {
                cubeBuilder.addCube(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16 - distanceFromEdge);
                break;
            }
            case UP: {
                cubeBuilder.addCube(6.0f, 10.0f, 6.0f, 10.0f, 16 - distanceFromEdge, 10.0f);
                break;
            }
            case WEST: {
                cubeBuilder.addCube(distanceFromEdge, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
            }
        }
    }

    public void addCoveredConnection(EnumFacing facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, List<BakedQuad> quadsOut) {
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        if (connectionType != AECableType.GLASS && !cableBusAdjacent) {
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
        }
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
    }

    public void addStraightCoveredConnection(EnumFacing facing, AEColor cableColor, List<BakedQuad> quadsOut) {
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
    }

    private static void setStraightCableUVs(CubeBuilder cubeBuilder, EnumFacing facing, int x, int y) {
        switch (facing) {
            case DOWN: 
            case UP: {
                cubeBuilder.setCustomUv(EnumFacing.NORTH, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(EnumFacing.EAST, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(EnumFacing.SOUTH, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(EnumFacing.WEST, x, 0.0f, y, x);
                break;
            }
            case EAST: 
            case WEST: {
                cubeBuilder.setCustomUv(EnumFacing.UP, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(EnumFacing.DOWN, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(EnumFacing.NORTH, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(EnumFacing.SOUTH, 0.0f, x, x, y);
                break;
            }
            case NORTH: 
            case SOUTH: {
                cubeBuilder.setCustomUv(EnumFacing.UP, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(EnumFacing.DOWN, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(EnumFacing.EAST, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(EnumFacing.WEST, 0.0f, x, x, y);
            }
        }
    }

    public void addConstrainedCoveredConnection(EnumFacing facing, AEColor cableColor, int distanceFromEdge, List<BakedQuad> quadsOut) {
        if (distanceFromEdge >= 5) {
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
    }

    public void addSmartConnection(EnumFacing facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, int channels, List<BakedQuad> quadsOut) {
        if (connectionType == AECableType.COVERED || connectionType == AECableType.GLASS) {
            this.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        TextureAtlasSprite oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        TextureAtlasSprite evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        if (connectionType != AECableType.GLASS && !cableBusAdjacent) {
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
            cubeBuilder.setRenderFullBright(true);
            cubeBuilder.setTexture(oddChannel);
            cubeBuilder.setColorRGB(cableColor.blackVariant);
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
            cubeBuilder.setTexture(evenChannel);
            cubeBuilder.setColorRGB(cableColor.whiteVariant);
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
            cubeBuilder.setRenderFullBright(false);
            cubeBuilder.setTexture(texture);
        }
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setRenderFullBright(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
    }

    public void addStraightSmartConnection(EnumFacing facing, AEColor cableColor, int channels, List<BakedQuad> quadsOut) {
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
        TextureAtlasSprite oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        TextureAtlasSprite evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setRenderFullBright(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
    }

    public void addConstrainedSmartConnection(EnumFacing facing, AEColor cableColor, int distanceFromEdge, int channels, List<BakedQuad> quadsOut) {
        if (distanceFromEdge >= 5) {
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
        TextureAtlasSprite oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        TextureAtlasSprite evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setRenderFullBright(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
    }

    public void addDenseCoveredConnection(EnumFacing facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, List<BakedQuad> quadsOut) {
        if (connectionType == AECableType.COVERED || connectionType == AECableType.SMART || connectionType == AECableType.GLASS) {
            this.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.DENSE_COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setRenderFullBright(false);
        cubeBuilder.setTexture(texture);
    }

    public void addDenseSmartConnection(EnumFacing facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, int channels, List<BakedQuad> quadsOut) {
        if (connectionType == AECableType.SMART) {
            this.addSmartConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, quadsOut);
            return;
        }
        if (connectionType == AECableType.COVERED || connectionType == AECableType.GLASS) {
            this.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.DENSE_SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        channels = (channels + 3) / 4;
        TextureAtlasSprite oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        TextureAtlasSprite evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setRenderFullBright(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setRenderFullBright(false);
        cubeBuilder.setTexture(texture);
    }

    public void addStraightDenseCoveredConnection(EnumFacing facing, AEColor cableColor, List<BakedQuad> quadsOut) {
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.DENSE_COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
    }

    public void addStraightDenseSmartConnection(EnumFacing facing, AEColor cableColor, int channels, List<BakedQuad> quadsOut) {
        CubeBuilder cubeBuilder = new CubeBuilder(this.format, quadsOut);
        TextureAtlasSprite texture = this.connectionTextures.get((Object)AECableType.DENSE_SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
        channels = (channels + 3) / 4;
        TextureAtlasSprite oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        TextureAtlasSprite evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setRenderFullBright(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
    }

    private static void addDenseCableSizedCube(EnumFacing facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case DOWN: {
                cubeBuilder.addCube(4.0f, 0.0f, 4.0f, 12.0f, 5.0f, 12.0f);
                break;
            }
            case EAST: {
                cubeBuilder.addCube(11.0f, 4.0f, 4.0f, 16.0f, 12.0f, 12.0f);
                break;
            }
            case NORTH: {
                cubeBuilder.addCube(4.0f, 4.0f, 0.0f, 12.0f, 12.0f, 5.0f);
                break;
            }
            case SOUTH: {
                cubeBuilder.addCube(4.0f, 4.0f, 11.0f, 12.0f, 12.0f, 16.0f);
                break;
            }
            case UP: {
                cubeBuilder.addCube(4.0f, 11.0f, 4.0f, 12.0f, 16.0f, 12.0f);
                break;
            }
            case WEST: {
                cubeBuilder.addCube(0.0f, 4.0f, 4.0f, 5.0f, 12.0f, 12.0f);
            }
        }
    }

    private static void addStraightDenseCableSizedCube(EnumFacing facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case DOWN: 
            case UP: {
                cubeBuilder.setUvRotation(EnumFacing.EAST, 3);
                cubeBuilder.addCube(3.0f, 0.0f, 3.0f, 13.0f, 16.0f, 13.0f);
                cubeBuilder.setUvRotation(EnumFacing.EAST, 0);
                break;
            }
            case EAST: 
            case WEST: {
                cubeBuilder.setUvRotation(EnumFacing.SOUTH, 3);
                cubeBuilder.setUvRotation(EnumFacing.NORTH, 3);
                cubeBuilder.addCube(0.0f, 3.0f, 3.0f, 16.0f, 13.0f, 13.0f);
                cubeBuilder.setUvRotation(EnumFacing.SOUTH, 0);
                cubeBuilder.setUvRotation(EnumFacing.NORTH, 0);
                break;
            }
            case NORTH: 
            case SOUTH: {
                cubeBuilder.setUvRotation(EnumFacing.EAST, 3);
                cubeBuilder.setUvRotation(EnumFacing.WEST, 3);
                cubeBuilder.addCube(3.0f, 3.0f, 0.0f, 13.0f, 13.0f, 16.0f);
                cubeBuilder.setUvRotation(EnumFacing.EAST, 0);
                cubeBuilder.setUvRotation(EnumFacing.WEST, 0);
            }
        }
    }

    private static void addCoveredCableSizedCube(EnumFacing facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case DOWN: {
                cubeBuilder.addCube(6.0f, 0.0f, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case EAST: {
                cubeBuilder.addCube(11.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                cubeBuilder.addCube(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 5.0f);
                break;
            }
            case SOUTH: {
                cubeBuilder.addCube(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                cubeBuilder.addCube(6.0f, 11.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                cubeBuilder.addCube(0.0f, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
            }
        }
    }

    private static void addStraightCoveredCableSizedCube(EnumFacing facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case DOWN: 
            case UP: {
                cubeBuilder.setUvRotation(EnumFacing.EAST, 3);
                cubeBuilder.addCube(5.0f, 0.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                cubeBuilder.setUvRotation(EnumFacing.EAST, 0);
                break;
            }
            case EAST: 
            case WEST: {
                cubeBuilder.setUvRotation(EnumFacing.SOUTH, 3);
                cubeBuilder.setUvRotation(EnumFacing.NORTH, 3);
                cubeBuilder.addCube(0.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                cubeBuilder.setUvRotation(EnumFacing.SOUTH, 0);
                cubeBuilder.setUvRotation(EnumFacing.NORTH, 0);
                break;
            }
            case NORTH: 
            case SOUTH: {
                cubeBuilder.setUvRotation(EnumFacing.EAST, 3);
                cubeBuilder.setUvRotation(EnumFacing.WEST, 3);
                cubeBuilder.addCube(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 16.0f);
                cubeBuilder.setUvRotation(EnumFacing.EAST, 0);
                cubeBuilder.setUvRotation(EnumFacing.WEST, 0);
            }
        }
    }

    private static void addCoveredCableSizedCube(EnumFacing facing, int distanceFromEdge, CubeBuilder cubeBuilder) {
        switch (facing) {
            case DOWN: {
                cubeBuilder.addCube(6.0f, distanceFromEdge, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case EAST: {
                cubeBuilder.addCube(11.0f, 6.0f, 6.0f, 16 - distanceFromEdge, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                cubeBuilder.addCube(6.0f, 6.0f, distanceFromEdge, 10.0f, 10.0f, 5.0f);
                break;
            }
            case SOUTH: {
                cubeBuilder.addCube(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16 - distanceFromEdge);
                break;
            }
            case UP: {
                cubeBuilder.addCube(6.0f, 11.0f, 6.0f, 10.0f, 16 - distanceFromEdge, 10.0f);
                break;
            }
            case WEST: {
                cubeBuilder.addCube(distanceFromEdge, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
            }
        }
    }

    private void addBigCoveredCableSizedCube(EnumFacing facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case DOWN: {
                cubeBuilder.addCube(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                break;
            }
            case EAST: {
                cubeBuilder.addCube(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                break;
            }
            case NORTH: {
                cubeBuilder.addCube(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                break;
            }
            case SOUTH: {
                cubeBuilder.addCube(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                break;
            }
            case UP: {
                cubeBuilder.addCube(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                break;
            }
            case WEST: {
                cubeBuilder.addCube(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
            }
        }
    }

    public static List<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        for (CableCoreType cableCoreType : CableCoreType.values()) {
            for (AEColor color : AEColor.values()) {
                locations.add(cableCoreType.getTexture(color));
            }
        }
        for (Enum enum_ : AECableType.VALIDCABLES) {
            for (AEColor color : AEColor.values()) {
                locations.add(CableBuilder.getConnectionTexture((AECableType)enum_, color));
            }
        }
        Collections.addAll(locations, SmartCableTextures.SMART_CHANNELS_TEXTURES);
        return locations;
    }

    public TextureAtlasSprite getCoreTexture(CableCoreType coreType, AEColor color) {
        return this.coreTextures.get((Object)coreType).get((Object)color);
    }
}

