/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.FLBlocks;
import com.rwtema.funkylocomotion.blocks.TileBooster;
import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.helper.WeakSet;
import com.rwtema.funkylocomotion.movers.MoveManager;
import com.rwtema.funkylocomotion.particles.ObstructionHelper;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class TileTeleport
extends TilePusher {
    static TLongObjectHashMap<WeakSet<TileTeleport>> cache = new TLongObjectHashMap();
    int teleportId;

    @Override
    public List<BlockPos> getBlocks(World world, BlockPos home, EnumFacing dir, boolean push) {
        BlockPos advance = home.func_177972_a(dir);
        if (BlockHelper.canStick(world, advance, dir.func_176734_d(), this.profile)) {
            return this.getBlocks(world, home, advance, null);
        }
        return null;
    }

    @Override
    public List<BlockPos> checkPositions(World srcWorld, EnumFacing moveDir, ArrayList<BlockPos> posList, HashSet<BlockPos> posSet) {
        TileTeleport tile = this.getTileTeleport();
        if (tile == null) {
            return null;
        }
        World dstWorld = tile.func_145831_w();
        boolean fail = false;
        for (BlockPos pos : posList) {
            BlockPos adv = this.getDestinationPos(tile, pos);
            if ((dstWorld != srcWorld || !posSet.contains(adv)) && BlockHelper.canReplace(dstWorld, adv)) continue;
            if (!ObstructionHelper.sendObstructionPacket(srcWorld, pos, moveDir)) {
                return null;
            }
            fail = true;
        }
        return fail ? null : posList;
    }

    private TileTeleport getTileTeleport() {
        if (this.teleportId == 0) {
            return null;
        }
        WeakSet tileTeleports = (WeakSet)cache.get((long)this.teleportId);
        if (tileTeleports == null) {
            return null;
        }
        Iterator iterator = tileTeleports.iterator();
        while (iterator.hasNext()) {
            TileTeleport tile = (TileTeleport)iterator.next();
            if (tile.func_145837_r()) {
                iterator.remove();
            }
            if (tile == this || !tile.func_145830_o()) continue;
            World world = tile.func_145831_w();
            if (world == null || world.field_72995_K) {
                iterator.remove();
            }
            if (DimensionManager.getWorld((int)world.field_73011_w.getDimension()) != world) {
                iterator.remove();
            }
            if (!world.func_175667_e(tile.func_174877_v())) continue;
            return tile;
        }
        return null;
    }

    private BlockPos getDestinationPos(TileTeleport tile, BlockPos pos) {
        BlockPos srcPos = this.field_174879_c.func_177972_a(EnumFacing.values()[this.func_145832_p()]);
        BlockPos dstPos = tile.field_174879_c.func_177972_a(EnumFacing.values()[tile.func_145832_p()]);
        return new BlockPos(pos.func_177958_n() - srcPos.func_177958_n() + dstPos.func_177958_n(), pos.func_177956_o() - srcPos.func_177956_o() + dstPos.func_177956_o(), pos.func_177952_p() - srcPos.func_177952_p() + dstPos.func_177952_p());
    }

    @Override
    public void startMoving() {
        boolean push;
        this.cooldown = -1;
        TileTeleport tileTeleport = this.getTileTeleport();
        if (tileTeleport == null) {
            return;
        }
        int meta = this.func_145832_p();
        EnumFacing dir = EnumFacing.values()[meta % 6];
        boolean bl = push = meta < 6;
        if (dir == null) {
            return;
        }
        List<BlockPos> posList = this.getBlocks(this.func_145831_w(), this.field_174879_c, dir, push);
        if (posList != null) {
            int energy = posList.size() * powerPerTile;
            if (this.energy.extractEnergy(energy, true) != energy) {
                ObstructionHelper.sendObstructionPacket(this.func_145831_w(), this.field_174879_c, null);
                return;
            }
            if (tileTeleport.energy.extractEnergy(energy, true) != energy) {
                return;
            }
            ArrayList<TileBooster> boosters = new ArrayList<TileBooster>(6);
            for (EnumFacing d : EnumFacing.values()) {
                TileEntity tile;
                if (d == dir) continue;
                BlockPos p = this.field_174879_c.func_177972_a(d);
                IBlockState state = this.func_145831_w().func_180495_p(p);
                if (state.func_177230_c() != FLBlocks.BOOSTER || state.func_177229_b((IProperty)BlockDirectional.field_176387_N) != d.func_176734_d() || !((tile = BlockHelper.getTile(this.func_145831_w(), p)) instanceof TileBooster)) continue;
                TileBooster booster = (TileBooster)tile;
                if (booster.energy.extractEnergy(energy, true) != energy) continue;
                boosters.add(booster);
            }
            if (!boosters.isEmpty()) {
                for (TileBooster booster : boosters) {
                    booster.energy.extractEnergy(energy, false);
                }
            }
            this.energy.extractEnergy(energy, false);
            tileTeleport.energy.extractEnergy(energy, false);
            ArrayList<MoveManager.BlockLink> links = new ArrayList<MoveManager.BlockLink>(posList.size());
            for (BlockPos blockPos : posList) {
                links.add(new MoveManager.BlockLink(blockPos, this.getDestinationPos(tileTeleport, blockPos)));
            }
            MoveManager.startMoving(this.func_145831_w(), tileTeleport.func_145831_w(), links, null, moveTime[boosters.size()] * 2);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unCache();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.unCache();
    }

    private void unCache() {
        WeakSet tileTeleports;
        if (!(this.teleportId == 0 || this.func_145831_w() != null && this.func_145831_w().field_72995_K || (tileTeleports = (WeakSet)cache.get((long)this.teleportId)) == null)) {
            tileTeleports.remove(this);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!(this.teleportId == 0 || this.func_145831_w() != null && this.func_145831_w().field_72995_K)) {
            WeakSet<TileTeleport> tileTeleports = (WeakSet<TileTeleport>)cache.get((long)this.teleportId);
            if (tileTeleports == null) {
                tileTeleports = new WeakSet<TileTeleport>();
                cache.put((long)this.teleportId, tileTeleports);
            }
            tileTeleports.add(this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.teleportId = tag.func_74762_e("ID");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("ID", this.teleportId);
        return tag;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74768_a("ID", this.teleportId);
        return tag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.teleportId = tag.func_74762_e("ID");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

