/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.handler.ConfigurationHandler;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.misc.EnderDyeButton;
import codechicken.enderstorage.misc.EnderKnobSlot;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEnderChest
extends TileFrequencyOwner {
    public double a_lidAngle;
    public double b_lidAngle;
    public int c_numOpen;
    public int rotation;
    public static EnderDyeButton[] buttons = new EnderDyeButton[3];

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!(this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L && this.c_numOpen == this.getStorage().getNumOpen())) {
            this.c_numOpen = this.getStorage().getNumOpen();
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.c_numOpen);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
        this.b_lidAngle = this.a_lidAngle;
        this.a_lidAngle = MathHelper.approachLinear((double)this.a_lidAngle, (double)(this.c_numOpen > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.b_lidAngle >= 0.5 && this.a_lidAngle < 0.5) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), ConfigurationHandler.useVanillaEnderChestSounds ? SoundEvents.field_187519_aI : SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.b_lidAngle == 0.0 && this.a_lidAngle > 0.0) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), ConfigurationHandler.useVanillaEnderChestSounds ? SoundEvents.field_187520_aJ : SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.c_numOpen = type;
            return true;
        }
        return false;
    }

    public double getRadianLidAngle(float frame) {
        double a = MathHelper.interpolate((double)this.b_lidAngle, (double)this.a_lidAngle, (double)frame);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * 3.141593 * -0.5;
    }

    @Override
    public EnderItemStorage getStorage() {
        return (EnderItemStorage)EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, "item");
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.rotation = packet.readUByte();
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.rotation = tag.func_74771_c("rot");
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit, EnumHand hand) {
        this.getStorage().openSMPGui(player, "tile.enderChest.name");
        return true;
    }

    public List<IndexedCuboid6> getIndexedCuboids() {
        ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375)));
        if (this.getRadianLidAngle(0.0f) < 0.0) {
            return cuboids;
        }
        for (int button = 0; button < 3; ++button) {
            EnderDyeButton ebutton = buttons[button].copy();
            ebutton.rotate(0.0, 0.5625, 0.0625, 1.0, 0.0, 0.0, 0.0);
            ebutton.rotateMeta(this.rotation);
            cuboids.add(new IndexedCuboid6((Object)(button + 1), new Cuboid6(ebutton.getMin(), ebutton.getMax())));
        }
        cuboids.add(new IndexedCuboid6((Object)4, new Cuboid6(new EnderKnobSlot(this.rotation).getSelectionBB())));
        return cuboids;
    }

    @Override
    public boolean rotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.func_189518_D_(), (World)this.field_145850_b, (int)(this.field_174879_c.func_177958_n() >> 4), (int)(this.field_174879_c.func_177952_p() >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        return Container.func_94526_b((IInventory)this.getStorage());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this.getStorage());
        }
        return (T)super.getCapability(capability, facing);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderChest.buttons[i] = new EnderDyeButton(i);
        }
    }
}

