/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.weather;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityDimensionInfo;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.PrecipitationType;
import org.orecruncher.dsurround.client.fx.ParticleCollections;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.sound.SoundBuilder;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.client.weather.NetherSplashRenderer;
import org.orecruncher.dsurround.client.weather.NullSplashRenderer;
import org.orecruncher.dsurround.client.weather.RenderWeather;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.client.weather.compat.RandomThings;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.gfx.ParticleHelper;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class StormSplashRenderer {
    protected static final int PARTICLE_SOUND_CHANCE = 3;
    private static final Int2ObjectOpenHashMap<StormSplashRenderer> splashRenderers = new Int2ObjectOpenHashMap();
    private static final StormSplashRenderer DEFAULT = new StormSplashRenderer();
    protected final Random RANDOM = new XorShiftRandom();
    protected final NoiseGeneratorSimplex GENERATOR = new NoiseGeneratorSimplex(this.RANDOM);
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected int rainSoundCounter = 0;

    public static void renderStormSplashes(int dimensionId, EntityRenderer renderer) {
        ((StormSplashRenderer)splashRenderers.get(dimensionId)).addRainParticles(renderer);
    }

    protected float calculateRainSoundVolume(World world) {
        float currentVolume = Weather.getCurrentVolume();
        float bounds = currentVolume * 0.25f;
        float adjust = MathHelper.func_76131_a((float)((float)(this.GENERATOR.func_151605_a((double)(world.func_72820_D() % 24000L / 100L), 1.0) / 5.0)), (float)(-bounds), (float)bounds);
        return MathHelper.func_76131_a((float)(currentVolume + adjust), (float)0.0f, (float)1.0f);
    }

    protected void spawnBlockParticle(IBlockState state, boolean dust, World world, double x, double y, double z) {
        Block block = state.func_177230_c();
        EnumParticleTypes particleType = null;
        if (dust || block == Blocks.field_150425_aM) {
            particleType = null;
        } else if ((block == Blocks.field_150424_aL || block == Blocks.field_189877_df) && this.RANDOM.nextInt(20) == 0) {
            particleType = EnumParticleTypes.LAVA;
        } else if (state.func_185904_a() == Material.field_151587_i) {
            particleType = EnumParticleTypes.SMOKE_NORMAL;
        } else if (WorldUtils.isFullWaterBlock((IBlockState)state)) {
            ParticleCollections.addWaterRipple(world, x, y, z);
        } else if (state.func_185904_a() != Material.field_151579_a) {
            ParticleCollections.addRainSplash(world, x, y, z);
        }
        if (particleType != null) {
            ParticleHelper.spawnParticle(particleType, (double)x, (double)y, (double)z);
        }
    }

    protected SoundEvent getBlockSoundFX(Block block, PrecipitationType pt) {
        if (pt == PrecipitationType.DUST) {
            return Weather.getWeatherProperties().getDustSound();
        }
        if (block == Blocks.field_150424_aL) {
            return SoundEvents.field_187662_cZ;
        }
        return Weather.getWeatherProperties().getStormSound();
    }

    protected BlockPos getPrecipitationHeight(ISeasonInfo season, int range, BlockPos pos) {
        return season.getPrecipitationHeight(pos);
    }

    protected boolean biomeHasDust(Biome biome) {
        return ModOptions.fog.allowDesertFog && !Weather.doVanilla() && BiomeUtil.getBiomeData(biome).getHasDust();
    }

    protected void playSplashSound(ISeasonInfo season, World world, Entity player2, double x, double y, double z) {
        this.pos.func_189532_c(x, y - 1.0, z);
        PrecipitationType pt = season.getPrecipitationType((BlockPos)this.pos, null);
        Block block = ClientChunkCache.instance().func_180495_p((BlockPos)this.pos).func_177230_c();
        SoundEvent sound2 = this.getBlockSoundFX(block, pt);
        if (sound2 != null) {
            float volume = this.calculateRainSoundVolume(world);
            float pitch = 1.0f;
            int playerY = MathHelper.func_76128_c((double)player2.field_70163_u);
            this.pos.func_189532_c(player2.field_70165_t, 0.0, player2.field_70161_v);
            if (y > player2.field_70163_u + 1.0 && season.getPrecipitationHeight((BlockPos)this.pos).func_177956_o() > playerY) {
                pitch = 0.5f;
            }
            this.pos.func_189532_c(x, y, z);
            SoundInstance fx = SoundBuilder.builder(sound2, SoundCategory.WEATHER).setVolume(volume).setPitch(pitch -= (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.1f).setPosition((BlockPos)this.pos).build();
            SoundEffectHandler.INSTANCE.playSound(fx);
        }
    }

    public void addRainParticles(EntityRenderer theThis) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74362_aa == 2) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (!CapabilityDimensionInfo.getCapability((World)world).hasWeather()) {
            return;
        }
        float rainStrengthFactor = Weather.getIntensityLevel();
        if (!mc.field_71474_y.field_74347_j) {
            rainStrengthFactor /= 2.0f;
        }
        if (rainStrengthFactor <= 0.0f) {
            return;
        }
        this.RANDOM.setSeed((long)RenderWeather.rendererUpdateCount * 312987231L);
        Entity entity = mc.func_175606_aa();
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        double spawnX = 0.0;
        double spawnY = 0.0;
        double spawnZ = 0.0;
        int particlesSpawned = 0;
        int RANGE = Math.max((ModOptions.effects.specialEffectRange + 1) / 2, 10);
        float rangeFactor = (float)RANGE / 10.0f;
        int particleCount = (int)(100.0f * rainStrengthFactor * rainStrengthFactor * rangeFactor);
        if (mc.field_71474_y.field_74362_aa == 1) {
            particleCount >>= 1;
        }
        ISeasonInfo season = CapabilitySeasonInfo.getCapability((World)world);
        for (int j1 = 0; j1 < particleCount; ++j1) {
            boolean hasDust;
            int locX = playerX + this.RANDOM.nextInt(RANGE) - this.RANDOM.nextInt(RANGE);
            int locZ = playerZ + this.RANDOM.nextInt(RANGE) - this.RANDOM.nextInt(RANGE);
            this.pos.func_181079_c(locX, 0, locZ);
            if (!RandomThings.shouldRain((World)world, (BlockPos)this.pos)) continue;
            BlockPos precipHeight = this.getPrecipitationHeight(season, RANGE / 2, (BlockPos)this.pos);
            PrecipitationType pt = season.getPrecipitationType(precipHeight, null);
            boolean bl = hasDust = pt == PrecipitationType.DUST;
            if (!hasDust && pt != PrecipitationType.RAIN || precipHeight.func_177956_o() > playerY + RANGE || precipHeight.func_177956_o() < playerY - RANGE) continue;
            BlockPos blockPos = precipHeight.func_177977_b();
            IBlockState state = ClientChunkCache.instance().func_180495_p(blockPos);
            double posX = (float)locX + this.RANDOM.nextFloat();
            double posY = (double)((float)precipHeight.func_177956_o() + 0.1f) - state.func_185900_c((IBlockAccess)world, (BlockPos)blockPos).field_72338_b;
            double posZ = (float)locZ + this.RANDOM.nextFloat();
            this.spawnBlockParticle(state, hasDust, (World)world, posX, posY, posZ);
            if (this.RANDOM.nextInt(++particlesSpawned) != 0) continue;
            spawnX = posX;
            spawnY = posY;
            spawnZ = posZ;
        }
        if (particlesSpawned > 0 && this.RANDOM.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            this.playSplashSound(season, (World)world, entity, spawnX, spawnY, spawnZ);
        }
    }

    static {
        splashRenderers.defaultReturnValue((Object)DEFAULT);
        splashRenderers.put(-1, (Object)new NetherSplashRenderer());
        splashRenderers.put(1, (Object)new NullSplashRenderer());
    }
}

