/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.weather;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.PrecipitationType;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.weather.StormSplashRenderer;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.gfx.ParticleHelper;

@SideOnly(value=Side.CLIENT)
public class NetherSplashRenderer
extends StormSplashRenderer {
    @Override
    protected SoundEvent getBlockSoundFX(Block block, PrecipitationType pt) {
        return pt == PrecipitationType.DUST ? Weather.getWeatherProperties().getDustSound() : null;
    }

    @Override
    protected void spawnBlockParticle(IBlockState state, boolean dust, World world, double x, double y, double z) {
        if (dust) {
            ParticleHelper.spawnParticle((EnumParticleTypes)EnumParticleTypes.SMOKE_NORMAL, (double)x, (double)y, (double)z);
        }
    }

    @Override
    protected BlockPos getPrecipitationHeight(ISeasonInfo season, int range, BlockPos pos) {
        int y = EnvironStateHandler.EnvironState.getPlayerPosition().func_177956_o();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(pos);
        boolean airBlockFound = false;
        for (int i = range; i >= -range; --i) {
            p.func_185336_p(y + i);
            IBlockState state = ClientChunkCache.instance().func_180495_p((BlockPos)p);
            Material material = state.func_185904_a();
            if (airBlockFound && material != Material.field_151579_a && material.func_76220_a()) {
                return new BlockPos(pos.func_177958_n(), y + i + 1, pos.func_177952_p());
            }
            if (material != Material.field_151579_a) continue;
            airBlockFound = true;
        }
        return new BlockPos(pos.func_177958_n(), 128, pos.func_177952_p());
    }
}

