/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.sound;

import com.google.common.base.MoreObjects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.client.fx.ISpecialEffect;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.sound.SoundBuilder;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.client.sound.TrackingSoundInstance;
import org.orecruncher.dsurround.expression.ExpressionEngine;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.config.SoundConfig;
import org.orecruncher.dsurround.registry.config.SoundType;
import org.orecruncher.dsurround.registry.sound.SoundMetadata;
import org.orecruncher.dsurround.registry.sound.SoundRegistry;
import org.orecruncher.lib.WeightTable;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public final class SoundEffect
implements ISpecialEffect,
WeightTable.IEntrySource<SoundEffect>,
WeightTable.IItem<SoundEffect> {
    private static final int SPOT_SOUND_RANGE = 8;
    private static final float[] pitchDelta = new float[]{-0.2f, 0.0f, 0.0f, 0.2f, 0.2f, 0.2f};
    private static final Random RANDOM = XorShiftRandom.current();
    private final SoundEvent sound;
    private final String soundName;
    private SoundType type;
    private String conditions;
    private SoundCategory category;
    private float volume;
    private float pitch;
    private int weight;
    private boolean variable;
    private int repeatDelayRandom;
    private int repeatDelay;
    private String soundTitle = "";

    protected SoundEffect(ResourceLocation resource, SoundCategory category) {
        this(resource, category, 1.0f, 1.0f, 0, false);
    }

    protected SoundEffect(ResourceLocation resource, SoundCategory category, float volume, float pitch, int repeatDelay, boolean variable) {
        this.soundName = resource.toString();
        this.sound = RegistryManager.SOUND.getSound(resource);
        this.volume = volume;
        this.pitch = pitch;
        this.conditions = "";
        this.weight = 10;
        this.type = SoundType.SPOT;
        this.category = (SoundCategory)MoreObjects.firstNonNull((Object)category, (Object)SoundCategory.BLOCKS);
        this.variable = variable;
        this.repeatDelayRandom = 0;
        this.repeatDelay = repeatDelay;
    }

    protected SoundEffect setVolume(float vol) {
        this.volume = vol;
        return this;
    }

    protected SoundEffect setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    protected SoundEffect setVariable(boolean flag) {
        this.variable = flag;
        return this;
    }

    protected SoundEffect setSoundCategory(@Nonnull SoundCategory cat) {
        this.category = cat;
        return this;
    }

    protected SoundEffect setConditions(@Nonnull String cond) {
        this.conditions = cond;
        return this;
    }

    protected SoundEffect setWeight(int w) {
        this.weight = w;
        return this;
    }

    protected SoundEffect setSoundType(@Nonnull SoundType type) {
        this.type = type;
        return this;
    }

    protected SoundEffect setRepeatDelay(int d) {
        this.repeatDelay = d;
        return this;
    }

    protected SoundEffect setRepeatDelayRandom(int r) {
        this.repeatDelayRandom = r;
        return this;
    }

    protected SoundEffect setSoundTitle(@Nonnull String title) {
        this.soundTitle = title;
        return this;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public String getSoundTitle() {
        return this.soundTitle;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundCategory getCategory() {
        return this.category;
    }

    public SoundType getSoundType() {
        return this.type;
    }

    protected float getVolume() {
        return this.volume;
    }

    protected float getPitch(Random rand) {
        if (rand != null && this.variable) {
            return this.pitch + pitchDelta[rand.nextInt(pitchDelta.length)];
        }
        return this.pitch;
    }

    protected int getRepeat(Random rand) {
        if (this.repeatDelayRandom <= 0) {
            return Math.max(this.repeatDelay, 0);
        }
        return this.repeatDelay + rand.nextInt(this.repeatDelayRandom);
    }

    protected boolean isRepeatable() {
        return this.type == SoundType.PERIODIC || this.type == SoundType.BACKGROUND;
    }

    private float randomRange(int range) {
        return RANDOM.nextInt(range) - RANDOM.nextInt(range);
    }

    @SideOnly(value=Side.CLIENT)
    public SoundInstance createSoundAt(@Nonnull BlockPos pos) {
        return SoundBuilder.builder(this.sound, SoundRegistry.BIOME).setPosition(pos).build();
    }

    @SideOnly(value=Side.CLIENT)
    public SoundInstance createSoundNear(@Nonnull Entity player2) {
        float posX = (float)(player2.field_70165_t + (double)this.randomRange(8));
        float posY = (float)(player2.field_70163_u + (double)player2.func_70047_e() + (double)this.randomRange(8));
        float posZ = (float)(player2.field_70161_v + (double)this.randomRange(8));
        return SoundBuilder.builder(this.sound, SoundRegistry.BIOME).setPosition(posX, posY, posZ).build();
    }

    @SideOnly(value=Side.CLIENT)
    public SoundInstance createTrackingSound(@Nonnull Entity player2, boolean fadeIn) {
        TrackingSoundInstance sound2 = new TrackingSoundInstance(player2, this, fadeIn);
        if (EnvironStateHandler.EnvironState.isPlayer(player2)) {
            sound2.setAttenuationType(ISound.AttenuationType.NONE);
        }
        return sound2;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return true;
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        SoundEffectHandler.INSTANCE.playSoundAt(pos, this, 0);
    }

    public boolean equals(Object anObj) {
        return this == anObj || this.soundName.equals(((SoundEffect)anObj).soundName);
    }

    public int hashCode() {
        return this.sound.hashCode();
    }

    public SoundEffect getItem() {
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public WeightTable.IItem<SoundEffect> getEntry() {
        return this;
    }

    public boolean matches() {
        return ExpressionEngine.instance().check(this.conditions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.soundName);
        builder.append('(').append(this.conditions).append(')');
        builder.append(", v:").append(this.volume);
        builder.append(", p:").append(this.pitch);
        builder.append(", t:").append((Object)this.type);
        if (this.type == SoundType.SPOT) {
            builder.append(", w:").append(this.weight);
        }
        if (this.repeatDelay != 0 || this.repeatDelayRandom != 0) {
            builder.append(", d:").append(this.repeatDelay).append('+').append(this.repeatDelayRandom);
        }
        return builder.toString();
    }

    public static class Builder {
        private final SoundEffect effect;

        public Builder(@Nonnull String sound2, @Nonnull SoundCategory cat) {
            this(new ResourceLocation("dsurround", sound2), cat);
        }

        public Builder(@Nonnull SoundEvent event, @Nonnull SoundCategory cat) {
            this(event.func_187503_a(), cat);
        }

        public Builder(@Nonnull ResourceLocation resource, @Nonnull SoundCategory cat) {
            this.effect = new SoundEffect(resource, cat);
        }

        public Builder(@Nonnull SoundConfig record) {
            ResourceLocation resource = new ResourceLocation(record.sound);
            this.effect = new SoundEffect(resource, null);
            this.setConditions(StringUtils.isEmpty((CharSequence)record.conditions) ? "" : record.conditions.intern());
            this.setVolume(record.volume == null ? 1.0f : record.volume.floatValue());
            this.setPitch(record.pitch == null ? 1.0f : record.pitch.floatValue());
            this.setWeight(record.weight == null ? 10 : record.weight);
            this.setVariablePitch(record.variable != null && record.variable != false);
            this.setRepeatDelay(record.repeatDelay == null ? 0 : record.repeatDelay);
            this.setRepeatDelayRandom(record.repeatDelayRandom == null ? 0 : record.repeatDelayRandom);
            this.setSoundTitle(record.title != null ? record.title : "");
            SoundType t = null;
            if (record.soundType != null) {
                t = SoundType.getType(record.soundType);
            }
            if (t == null) {
                t = record.repeatDelay != null && record.repeatDelay > 0 ? SoundType.PERIODIC : (record.spotSound != null && record.spotSound != false ? SoundType.SPOT : SoundType.BACKGROUND);
            }
            this.setSoundType(t);
            SoundCategory sc = null;
            if (record.soundCategory != null) {
                sc = SoundCategory.func_187950_a((String)record.soundCategory);
            }
            if (sc == null) {
                SoundMetadata meta = RegistryManager.SOUND.getSoundMetadata(resource);
                if (meta != null) {
                    sc = meta.getCategory();
                }
                if (sc == null) {
                    sc = SoundCategory.AMBIENT;
                }
            }
            this.setSoundCategory(sc);
        }

        public Builder setSoundTitle(@Nonnull String title) {
            this.effect.setSoundTitle(title);
            return this;
        }

        public Builder setVolume(float v) {
            this.effect.setVolume(v);
            return this;
        }

        public Builder setPitch(float p) {
            this.effect.setPitch(p);
            return this;
        }

        public Builder setVariablePitch(boolean flag) {
            this.effect.setVariable(flag);
            return this;
        }

        public Builder setSoundCategory(@Nonnull SoundCategory cat) {
            this.effect.setSoundCategory(cat);
            return this;
        }

        public Builder setConditions(@Nonnull String cond) {
            this.effect.setConditions(cond == null ? "" : cond);
            return this;
        }

        public Builder setWeight(int w) {
            this.effect.setWeight(w);
            return this;
        }

        public Builder setRepeatDelay(int d) {
            this.effect.setRepeatDelay(d);
            return this;
        }

        public Builder setRepeatDelayRandom(int r) {
            this.effect.setRepeatDelayRandom(r);
            return this;
        }

        public Builder setSoundType(SoundType type) {
            this.effect.setSoundType(type);
            return this;
        }

        public SoundEffect build() {
            return this.effect;
        }
    }
}

