/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.aurora.AuroraFactory;
import org.orecruncher.dsurround.client.aurora.AuroraUtils;
import org.orecruncher.dsurround.client.aurora.IAurora;
import org.orecruncher.dsurround.client.handlers.DiagnosticHandler;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EffectManager;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.event.DiagnosticEvent;
import org.orecruncher.dsurround.lib.OutOfBandTimerEMA;
import org.orecruncher.lib.DiurnalUtils;
import org.orecruncher.lib.math.TimerEMA;

@SideOnly(value=Side.CLIENT)
public final class AuroraEffectHandler
extends EffectHandlerBase {
    private IAurora current;
    private int dimensionId;
    private final TimerEMA timer = new OutOfBandTimerEMA("Aurora Render");
    private long nanos;

    public AuroraEffectHandler() {
        super("Aurora Effect");
    }

    @Override
    public void onConnect() {
        this.current = null;
        ((DiagnosticHandler)EffectManager.instance().lookupService(DiagnosticHandler.class)).addTimer(this.timer);
    }

    @Override
    public void onDisconnect() {
        this.current = null;
    }

    private boolean isAuroraVisible() {
        DiurnalUtils.DayCycle dc = EnvironStateHandler.EnvironState.getDayCycle();
        return dc == DiurnalUtils.DayCycle.SUNSET || dc == DiurnalUtils.DayCycle.NIGHTTIME;
    }

    private boolean spawnAurora(@Nonnull World world) {
        if (!ModOptions.aurora.auroraEnable) {
            return false;
        }
        if (this.current != null || Minecraft.func_71410_x().field_71474_y.field_151451_c < 6 || !this.isAuroraVisible()) {
            return false;
        }
        return AuroraUtils.hasAuroras() && EnvironStateHandler.EnvironState.getTruePlayerBiome().getHasAurora();
    }

    private boolean canAuroraStay(@Nonnull World world) {
        if (!ModOptions.aurora.auroraEnable) {
            return false;
        }
        return Minecraft.func_71410_x().field_71474_y.field_151451_c < 6 || this.isAuroraVisible() && EnvironStateHandler.EnvironState.getTruePlayerBiome().getHasAurora();
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        if (this.current != null) {
            if (this.current.isComplete() || this.dimensionId != EnvironStateHandler.EnvironState.getDimensionId() || !ModOptions.aurora.auroraEnable) {
                this.current = null;
            } else {
                this.current.update();
                boolean isDying = this.current.isDying();
                boolean canStay = this.canAuroraStay(player2.func_130014_f_());
                if (isDying && canStay) {
                    ModBase.log().debug("Unfading aurora...", new Object[0]);
                    this.current.setFading(false);
                } else if (!isDying && !canStay) {
                    ModBase.log().debug("Aurora fade...", new Object[0]);
                    this.current.setFading(true);
                }
            }
        }
        if (this.spawnAurora(player2.func_130014_f_())) {
            this.current = AuroraFactory.produce(AuroraUtils.getSeed());
            ModBase.log().debug("New aurora [%s]", new Object[]{this.current.toString()});
        }
        this.dimensionId = EnvironStateHandler.EnvironState.getDimensionId();
        this.timer.update((double)this.nanos);
        this.nanos = 0L;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void doRender(@Nonnull RenderWorldLastEvent event) {
        if (this.current != null) {
            long start = System.nanoTime();
            this.current.render(event.getPartialTicks());
            this.nanos += System.nanoTime() - start;
        }
    }

    @SubscribeEvent
    public void diagnostic(@Nonnull DiagnosticEvent.Gather event) {
        event.output.add("Aurora: " + (this.current == null ? "NONE" : this.current.toString()));
    }
}

