/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.effects;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.effects.EffectStateBase;
import org.orecruncher.dsurround.client.effects.EventEffect;
import org.orecruncher.dsurround.client.effects.IEventEffectLibraryState;
import org.orecruncher.dsurround.client.effects.IParticleHelper;
import org.orecruncher.dsurround.client.effects.ISoundHelper;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.client.sound.SoundInstance;

@SideOnly(value=Side.CLIENT)
public class EventEffectLibrary
extends EffectStateBase
implements IEventEffectLibraryState {
    protected final List<EventEffect> effects = new ArrayList<EventEffect>();

    public EventEffectLibrary(@Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        super(ph, sh);
    }

    public void register(@Nonnull EventEffect effect) {
        effect.setState(this);
        this.effects.add(effect);
        MinecraftForge.EVENT_BUS.register((Object)effect);
    }

    public void cleanup() {
        this.effects.forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).unregister(arg_0));
        this.effects.clear();
    }

    @Override
    public boolean isActivePlayer(@Nonnull Entity player2) {
        EntityPlayerSP ep = Minecraft.func_71410_x().field_71439_g;
        return ep != null && ep.func_145782_y() == player2.func_145782_y();
    }

    @Override
    @Nonnull
    public SoundInstance createSound(@Nonnull SoundEffect se, @Nonnull Entity player2) {
        if (this.isActivePlayer(player2)) {
            return se.createTrackingSound(player2, false);
        }
        return se.createSoundNear(player2);
    }
}

