/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.entitydata;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityDataSettable;
import org.orecruncher.dsurround.network.Network;
import org.orecruncher.dsurround.network.PacketEntityData;

public final class EntityData
implements IEntityDataSettable {
    public static final int NO_ENTITY = -1;
    private final Entity entity;
    private boolean isAttacking;
    private boolean isFleeing;
    private boolean isDirty;

    public EntityData() {
        this.entity = null;
    }

    public EntityData(@Nonnull Entity entity) {
        this.entity = entity;
    }

    @Override
    public int getEntityId() {
        return this.entity != null ? this.entity.func_145782_y() : -1;
    }

    @Override
    public boolean isAttacking() {
        return this.isAttacking;
    }

    @Override
    public void setAttacking(boolean flag) {
        this.isDirty = this.isAttacking != flag | this.isDirty;
        this.isAttacking = flag;
    }

    @Override
    public boolean isFleeing() {
        return this.isFleeing;
    }

    @Override
    public void setFleeing(boolean flag) {
        this.isDirty = this.isFleeing != flag | this.isDirty;
        this.isFleeing = flag;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    public void sync() {
        if (this.entity != null && !this.entity.field_70170_p.field_72995_K) {
            Network.sendToEntityViewers(this.entity, new PacketEntityData(this));
            this.clearDirty();
        }
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("a", this.isAttacking());
        nbt.func_74757_a("f", this.isFleeing());
        return nbt;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        this.setAttacking(nbt.func_74767_n("a"));
        this.setFleeing(nbt.func_74767_n("f"));
    }

    private static class NBT {
        public static final String ATTACKING = "a";
        public static final String FLEEING = "f";

        private NBT() {
        }
    }
}

