/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.orecruncher.dsurround.capabilities.entitydata.EntityData;
import org.orecruncher.dsurround.capabilities.entitydata.EntityDataTables;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityData;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityDataSettable;
import org.orecruncher.dsurround.network.Network;
import org.orecruncher.dsurround.network.PacketEntityData;
import org.orecruncher.lib.capability.CapabilityProviderSerializable;
import org.orecruncher.lib.capability.CapabilityUtils;
import org.orecruncher.lib.capability.SimpleStorage;

public final class CapabilityEntityData {
    @CapabilityInject(value=IEntityData.class)
    public static final Capability<IEntityData> ENTITY_DATA = null;
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("dsurround", "data");

    public static void register() {
        CapabilityManager.INSTANCE.register(IEntityData.class, (Capability.IStorage)new SimpleStorage(), EntityData::new);
    }

    public static IEntityData getCapability(@Nonnull Entity entity) {
        return (IEntityData)CapabilityUtils.getCapability((ICapabilityProvider)entity, ENTITY_DATA, null);
    }

    @Nonnull
    public static ICapabilityProvider createProvider(IEntityData data) {
        return new CapabilityProviderSerializable(ENTITY_DATA, null, (Object)data);
    }

    @Mod.EventBusSubscriber(modid="dsurround")
    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLiving) {
                EntityData emojiData = new EntityData((Entity)event.getObject());
                event.addCapability(CAPABILITY_ID, CapabilityEntityData.createProvider(emojiData));
            }
        }

        @SubscribeEvent
        public static void trackingEvent(@Nonnull PlayerEvent.StartTracking event) {
            IEntityData data;
            if (event.getTarget() instanceof EntityLiving && (data = (IEntityData)event.getTarget().getCapability(ENTITY_DATA, null)) != null) {
                Network.sendToPlayer((EntityPlayerMP)event.getEntityPlayer(), new PacketEntityData(data));
            }
        }

        @SubscribeEvent(receiveCanceled=false)
        public static void livingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
            Entity entity = event.getEntity();
            World world = entity.func_130014_f_();
            if (world.field_72995_K || entity.field_70173_aa % 5 != 0) {
                return;
            }
            IEntityDataSettable data = (IEntityDataSettable)CapabilityEntityData.getCapability(event.getEntity());
            if (data != null) {
                EntityDataTables.assess((EntityLiving)event.getEntity());
                if (data.isDirty()) {
                    data.sync();
                }
            }
        }
    }
}

