/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.container;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.container.SlotSeedAnalyzerJournal;
import com.infinityraider.agricraft.container.SlotSeedAnalyzerSeed;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.utility.ContainerHelper;
import com.infinityraider.infinitylib.container.ContainerTileBase;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerSeedAnalyzer
extends ContainerTileBase<TileEntitySeedAnalyzer> {
    public int progress;
    public static final int SEED_SLOT_ID = 36;
    public static final int JOURNAL_SLOT_ID = 37;

    public ContainerSeedAnalyzer(TileEntitySeedAnalyzer analyzer, InventoryPlayer inventory, SeedAnalyzerLayout layout) {
        super((TileEntity)analyzer, inventory, layout.offsetX, layout.offsetY);
        SlotSeedAnalyzerSeed slotSeed = new SlotSeedAnalyzerSeed((IInventory)this.getTile(), 36, layout.seedSlotX, layout.seedSlotY);
        SlotSeedAnalyzerJournal slotJournal = new SlotSeedAnalyzerJournal((IInventory)this.getTile(), 37, layout.journalSlotX, layout.journalSlotY);
        this.func_75146_a(slotSeed);
        this.func_75146_a(slotJournal);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            if (this.progress == ((TileEntitySeedAnalyzer)this.getTile()).getProgress()) continue;
            listener.func_71112_a((Container)this, 0, ((TileEntitySeedAnalyzer)this.getTile()).getProgress());
        }
        this.progress = ((TileEntitySeedAnalyzer)this.getTile()).getProgress();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int type, int newValue) {
        if (type == 0) {
            ((TileEntitySeedAnalyzer)this.getTile()).setProgress(newValue);
        }
    }

    public final boolean hasItem(Slot slot) {
        return slot != null && slot.func_75216_d();
    }

    public final ItemStack func_82846_b(EntityPlayer player, int clickedSlot) {
        int stop;
        int start;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlot);
        if (!this.hasItem(slot)) {
            return ItemStack.field_190927_a;
        }
        ItemStack slotStack = slot.func_75211_c();
        ItemStack itemstack = slotStack.func_77946_l();
        if (clickedSlot == 36 || clickedSlot == 37) {
            start = 0;
            stop = this.field_75151_b.size() - 2;
        } else {
            start = 36;
            stop = 38;
        }
        if (this.func_75135_a(slotStack, start, stop, false)) {
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            slot.func_190901_a(player, slotStack);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected final boolean func_75135_a(@Nonnull ItemStack stack, int start, int stop, boolean backwards) {
        int i;
        Preconditions.checkNotNull((Object)stack);
        if (start < 0 || stop < 0) {
            throw new IndexOutOfBoundsException("The specified slot range is impossible!");
        }
        if (stop < start) {
            int temp = start;
            start = stop;
            stop = temp;
            boolean bl = backwards = !backwards;
        }
        if (stack.func_190926_b()) {
            return true;
        }
        if (backwards) {
            for (i = start; i < stop; ++i) {
                ContainerHelper.attemptMergeIntoSlot((Slot)this.field_75151_b.get(i), stack);
                if (!stack.func_190926_b()) continue;
                return true;
            }
        } else {
            for (i = stop - 1; i >= start; --i) {
                ContainerHelper.attemptMergeIntoSlot((Slot)this.field_75151_b.get(i), stack);
                if (!stack.func_190926_b()) continue;
                return true;
            }
        }
        return stack.func_190926_b();
    }

    public static enum SeedAnalyzerLayout {
        NORMAL(8, 94, 80, 40, 152, 68),
        PERIPHERAL(5, 94, 77, 40, 149, 68);

        public final int offsetX;
        public final int offsetY;
        public final int seedSlotX;
        public final int seedSlotY;
        public final int journalSlotX;
        public final int journalSlotY;

        private SeedAnalyzerLayout(int offsetX, int offsetY, int seedSlotX, int seedSlotY, int journalSlotX, int journalSlotY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.seedSlotX = seedSlotX;
            this.seedSlotY = seedSlotY;
            this.journalSlotX = journalSlotX;
            this.journalSlotY = journalSlotY;
        }
    }
}

