/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.stretching;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.stretching.KeyStretching;

public class MasterKeyFromPasswordDerivation {
    private final KeyStretching stretching;

    public MasterKeyFromPasswordDerivation(KeyStretching stretching) {
        this.stretching = stretching;
    }

    public byte[] deriveKey(String salt, String masterPassword, int desiredKeyLengthBits) throws GeneralSecurityException {
        byte[] derivedKey = this.stretching.strengthenKey(this.byteRepresentationOf(salt), this.byteRepresentationOf(masterPassword), desiredKeyLengthBits);
        return derivedKey;
    }

    public byte[] deriveKey(byte[] salt, String masterPassword, int desiredKeyLengthBits) throws GeneralSecurityException {
        byte[] derivedKey = this.stretching.strengthenKey(salt, this.byteRepresentationOf(masterPassword), desiredKeyLengthBits);
        return derivedKey;
    }

    public byte[] deriveKey(byte[] salt, byte[] masterPassword, int desiredKeyLengthBits) throws GeneralSecurityException {
        byte[] derivedKey = this.stretching.strengthenKey(salt, masterPassword, desiredKeyLengthBits);
        return derivedKey;
    }

    private byte[] byteRepresentationOf(String identifier) {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(identifier));
        byte[] identifierByteRepresentation = new byte[buffer.limit()];
        buffer.get(identifierByteRepresentation);
        return identifierByteRepresentation;
    }
}

