/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.derivation;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.derivation.KeyDerivationFunction;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;

public class HKDFSHA256
implements KeyDerivationFunction {
    private final byte[] masterKey;

    public HKDFSHA256(byte[] masterKey) {
        this.masterKey = Arrays.copyOf(masterKey, masterKey.length);
    }

    @Override
    public byte[] deriveKey(@Nullable byte[] salt, byte[] info, int desiredKeyLengthInBits) throws GeneralSecurityException {
        if (desiredKeyLengthInBits % 8 != 0) {
            throw new IllegalArgumentException("desiredKeyLengthInBits must be multiple of 8 but is " + desiredKeyLengthInBits);
        }
        int desiredKeyLengthInBytes = desiredKeyLengthInBits / 8;
        HKDFParameters derivationParameters = new HKDFParameters(this.masterKey, salt, info);
        SHA256Digest digest = new SHA256Digest();
        HKDFBytesGenerator hkdfGenerator = new HKDFBytesGenerator(digest);
        hkdfGenerator.init(derivationParameters);
        byte[] hkdf = new byte[desiredKeyLengthInBytes];
        int generatedKeyLength = hkdfGenerator.generateBytes(hkdf, 0, hkdf.length);
        if (generatedKeyLength != desiredKeyLengthInBytes) {
            throw new GeneralSecurityException(String.format("Failed to derive key. Expected %d bytes, generated %d ", desiredKeyLengthInBytes, generatedKeyLength));
        }
        return hkdf;
    }
}

