/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.symmetric.keygeneration;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.derivation.KeyDerivationFunction;

public class DerivedKeyGenerator {
    private final KeyDerivationFunction kdFwithMasterKeyMixin;
    @Nullable
    private final byte[] salt;
    private static final int MAXIMUM_CONTEXT_ELEMENT_LENGTH = 65535;

    public DerivedKeyGenerator(KeyDerivationFunction kdFwithMasterKeyMixin, @Nullable byte[] salt) {
        this.kdFwithMasterKeyMixin = kdFwithMasterKeyMixin;
        this.salt = salt == null ? null : Arrays.copyOf(salt, salt.length);
    }

    public byte[] deriveKey(String contextName, String idUniqueInContext, String recordVersion, int desiredKeyLengthBytes) throws GeneralSecurityException {
        String derivedKeyIdentifierStr = this.constructDerivedKeyIdentifier(contextName, idUniqueInContext, recordVersion);
        byte[] derivedKeyIdentifier = this.byteRepresentationOf(derivedKeyIdentifierStr);
        byte[] derivedKey = this.kdFwithMasterKeyMixin.deriveKey(this.salt, derivedKeyIdentifier, desiredKeyLengthBytes * 8);
        return derivedKey;
    }

    public String constructDerivedKeyIdentifier(String contextName, String idUniqueInContext, String recordVersion) {
        if (contextName == null) {
            contextName = "";
        }
        if (contextName.length() > 65535) {
            throw new IllegalArgumentException("ContextName must be <= 65535 chars");
        }
        if (idUniqueInContext == null || idUniqueInContext.isEmpty()) {
            throw new IllegalArgumentException("idUniqueInContext must be set");
        }
        if (idUniqueInContext.length() > 65535) {
            throw new IllegalArgumentException("idUniqueInContext must be <= 65535 chars");
        }
        if (recordVersion == null || recordVersion.isEmpty()) {
            throw new IllegalArgumentException("recordVersion must be set");
        }
        if (recordVersion.length() > 65535) {
            throw new IllegalArgumentException("recordVersion must be <= 65535 chars");
        }
        return String.format("%04x:%s:%04x:%s:%04x:%s", contextName.length(), contextName, idUniqueInContext.length(), idUniqueInContext, recordVersion.length(), recordVersion);
    }

    private byte[] byteRepresentationOf(String identifier) {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(identifier));
        byte[] identifierByteRepresentation = new byte[buffer.limit()];
        buffer.get(identifierByteRepresentation);
        return identifierByteRepresentation;
    }
}

