/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.io.IOException;
import java.security.SignatureException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RequireSpecificSignatureValidationStrategy
implements SignatureValidationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequireSpecificSignatureValidationStrategy.class);
    private final Set<Long> signaturesRequiredForTheseKeys;

    RequireSpecificSignatureValidationStrategy(Collection<Long> signaturesRequiredForTheseKeys) {
        this.signaturesRequiredForTheseKeys = new HashSet<Long>(signaturesRequiredForTheseKeys);
    }

    @Override
    public void validateSignatures(PGPObjectFactory factory, Map<Long, PGPOnePassSignature> onePassSignatures) throws SignatureException, PGPException, IOException {
        PGPSignatureList signatureList = (PGPSignatureList)factory.nextObject();
        if (signatureList == null || signatureList.isEmpty()) {
            throw new PGPException("No signatures found!");
        }
        HashSet<Long> signaturesRequiredForTheseKeysCheckList = new HashSet<Long>(this.signaturesRequiredForTheseKeys);
        for (PGPSignature messageSignature : signatureList) {
            boolean isHasPubKeyForSignature;
            PGPOnePassSignature ops = onePassSignatures.get(messageSignature.getKeyID());
            boolean bl = isHasPubKeyForSignature = ops != null;
            if (isHasPubKeyForSignature) {
                boolean isThisSignatureGood = ops.verify(messageSignature);
                LOGGER.debug("{} validated signature with key 0x{}", (Object)(isThisSignatureGood ? "Successfully" : "Failed to"), (Object)Long.toHexString(messageSignature.getKeyID()));
                if (!isThisSignatureGood) continue;
                signaturesRequiredForTheseKeysCheckList.remove(messageSignature.getKeyID());
                continue;
            }
            LOGGER.debug("Could not validated signature with key 0x{} because we have no matching public key", (Object)Long.toHexString(messageSignature.getKeyID()));
        }
        boolean successfullyVerified = signaturesRequiredForTheseKeysCheckList.isEmpty();
        if (!successfullyVerified) {
            StringBuilder missingSignatures = new StringBuilder();
            for (Long key : signaturesRequiredForTheseKeysCheckList) {
                if (missingSignatures.length() != 0) {
                    missingSignatures.append(", ");
                }
                missingSignatures.append("0x");
                missingSignatures.append(Long.toHexString(key));
            }
            throw new SignatureException("Signature verification failed! The following signatures (from keys) could not be verified: " + missingSignatures.toString());
        }
        LOGGER.debug("Signature verification success");
    }

    @Override
    public boolean isRequireSignatureCheck() {
        return true;
    }
}

