/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.io.IOException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RequireSpecificSignatureValidationForUserIdsStrategy
implements SignatureValidationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequireSpecificSignatureValidationForUserIdsStrategy.class);
    private final Map<String, Set<Long>> keysByUid;

    RequireSpecificSignatureValidationForUserIdsStrategy(Map<String, Set<Long>> keysByUid) {
        this.keysByUid = new HashMap<String, Set<Long>>(keysByUid);
    }

    @Nullable
    private String uidForKeyId(long keyId) {
        for (String uid : this.keysByUid.keySet()) {
            Set<Long> keyIds = this.keysByUid.get(uid);
            if (!keyIds.contains(keyId)) continue;
            return uid;
        }
        return null;
    }

    @Override
    public void validateSignatures(PGPObjectFactory factory, Map<Long, PGPOnePassSignature> onePassSignatures) throws SignatureException, PGPException, IOException {
        PGPSignatureList signatureList = (PGPSignatureList)factory.nextObject();
        if (signatureList == null || signatureList.isEmpty()) {
            throw new PGPException("No signatures found!");
        }
        HashSet<String> signaturesRequiredForTheseKeysCheckList = new HashSet<String>(this.keysByUid.keySet());
        for (PGPSignature messageSignature : signatureList) {
            boolean isHasPubKeyForSignature;
            PGPOnePassSignature ops = onePassSignatures.get(messageSignature.getKeyID());
            boolean bl = isHasPubKeyForSignature = ops != null;
            if (isHasPubKeyForSignature) {
                boolean isThisSignatureGood = ops.verify(messageSignature);
                String uid = this.uidForKeyId(messageSignature.getKeyID());
                LOGGER.debug("{} validated signature with key 0x{} ({})", isThisSignatureGood ? "Successfully" : "Failed to", Long.toHexString(messageSignature.getKeyID()), uid == null ? "<unknown uid>" : uid);
                if (!isThisSignatureGood || uid == null) continue;
                signaturesRequiredForTheseKeysCheckList.remove(uid);
                continue;
            }
            LOGGER.debug("Could not validated signature with key 0x{} because we have no matching public key", (Object)Long.toHexString(messageSignature.getKeyID()));
        }
        boolean successfullyVerified = signaturesRequiredForTheseKeysCheckList.isEmpty();
        if (!successfullyVerified) {
            StringBuilder missingSignatures = new StringBuilder();
            for (String uid : signaturesRequiredForTheseKeysCheckList) {
                if (missingSignatures.length() != 0) {
                    missingSignatures.append(", ");
                }
                missingSignatures.append(uid);
            }
            throw new SignatureException("Signature verification failed! The following signatures (from keys) could not be verified: " + missingSignatures.toString());
        }
        LOGGER.debug("Signature verification success");
    }

    @Override
    public boolean isRequireSignatureCheck() {
        return true;
    }
}

