/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.reencryption;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.BuildEncryptionOutputStreamAPI;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.reencryption.ZipEntityStrategy;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExplodeAndReencrypt {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplodeAndReencrypt.class);
    private final ZipEntityStrategy entityHandlingStrategy;
    private final BuildEncryptionOutputStreamAPI.Build encryptionFactory;

    ExplodeAndReencrypt(ZipEntityStrategy entityHandlingStrategy, BuildEncryptionOutputStreamAPI.Build encryptionFactory) {
        this.entityHandlingStrategy = entityHandlingStrategy;
        this.encryptionFactory = encryptionFactory;
    }

    void explodeAndReencrypt(InputStream inputStream) throws IOException, SignatureException, NoSuchAlgorithmException, PGPException, NoSuchProviderException {
        ZipEntry entry;
        boolean zipDataFound = false;
        ZipInputStream zis = new ZipInputStream(inputStream);
        int numDirs = 0;
        int numFiles = 0;
        while ((entry = zis.getNextEntry()) != null) {
            String sanitizedFileName = this.entityHandlingStrategy.rewriteName(entry.getName());
            if (!entry.getName().equals(sanitizedFileName)) {
                LOGGER.trace("Rewriting '{}' to '{}'", (Object)entry.getName(), (Object)sanitizedFileName);
            }
            if (!zipDataFound) {
                zipDataFound = true;
                LOGGER.trace("Found ZIP Data");
            }
            if (entry.isDirectory()) {
                ++numDirs;
                LOGGER.debug("found directory '{}'", (Object)entry.getName());
                this.entityHandlingStrategy.handleDirectory(sanitizedFileName);
                continue;
            }
            ++numFiles;
            LOGGER.debug("found file '{}'", (Object)entry.getName());
            OutputStream outputStream = this.entityHandlingStrategy.createOutputStream(sanitizedFileName);
            Throwable throwable = null;
            try {
                if (outputStream == null) {
                    LOGGER.trace("Ignore {}", (Object)entry.getName());
                    continue;
                }
                OutputStream encryptedSmallFromZIP = this.encryptionFactory.andWriteTo(outputStream);
                Streams.pipeAll(zis, encryptedSmallFromZIP);
                encryptedSmallFromZIP.flush();
                encryptedSmallFromZIP.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (outputStream == null) continue;
                if (throwable != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                outputStream.close();
            }
        }
        if (zipDataFound) {
            LOGGER.debug("ZIP input stream closed. Created {} directories, and {} files.", (Object)numDirs, (Object)numFiles);
        } else {
            LOGGER.info("ZIP input stream closed. No ZIP data found.");
        }
    }
}

