/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

final class StreamBasedKeyringConfig
implements KeyringConfig {
    @Nonnull
    private final KeyringConfigCallback callback;
    private final PGPPublicKeyRingCollection publicKeyRings;
    private final PGPSecretKeyRingCollection secretKeyRings;
    private final KeyFingerPrintCalculator keyFingerPrintCalculator;

    static KeyringConfig build(KeyringConfigCallback callback, @Nullable InputStream publicKeyringStream, @Nullable InputStream secretKeyringStream) throws IOException, PGPException {
        PGPSecretKeyRingCollection secretKeyRings;
        PGPPublicKeyRingCollection publicKeyRings;
        if (callback == null) {
            throw new IllegalArgumentException("callback mus not be null");
        }
        BcKeyFingerprintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
        if (publicKeyringStream == null) {
            publicKeyRings = new PGPPublicKeyRingCollection(Collections.EMPTY_LIST);
        } else {
            publicKeyRings = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(publicKeyringStream), (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            StreamBasedKeyringConfig.close(publicKeyringStream);
        }
        if (secretKeyringStream == null) {
            secretKeyRings = new PGPSecretKeyRingCollection(Collections.EMPTY_LIST);
        } else {
            secretKeyRings = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(secretKeyringStream), (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            StreamBasedKeyringConfig.close(secretKeyringStream);
        }
        return new StreamBasedKeyringConfig(callback, keyFingerPrintCalculator, publicKeyRings, secretKeyRings);
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private StreamBasedKeyringConfig(KeyringConfigCallback callback, KeyFingerPrintCalculator keyFingerPrintCalculator, PGPPublicKeyRingCollection publicKeyRings, PGPSecretKeyRingCollection secretKeyRings) {
        this.callback = callback;
        this.keyFingerPrintCalculator = keyFingerPrintCalculator;
        this.publicKeyRings = publicKeyRings;
        this.secretKeyRings = secretKeyRings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StreamBasedKeyringConfig{");
        sb.append("callback=").append(this.callback);
        sb.append(", publicKeyRings=").append(this.publicKeyRings);
        sb.append(", secretKeyRings=").append(this.secretKeyRings == null ? "null" : "<present>");
        sb.append('}');
        return sb.toString();
    }

    @Override
    public PGPPublicKeyRingCollection getPublicKeyRings() throws IOException, PGPException {
        return this.publicKeyRings;
    }

    @Override
    public PGPSecretKeyRingCollection getSecretKeyRings() throws IOException, PGPException {
        return this.secretKeyRings;
    }

    @Override
    @Nullable
    public char[] decryptionSecretKeyPassphraseForSecretKeyId(long keyID) {
        return this.callback.decryptionSecretKeyPassphraseForSecretKeyId(keyID);
    }

    @Override
    public KeyFingerPrintCalculator getKeyFingerPrintCalculator() {
        return this.keyFingerPrintCalculator;
    }
}

