/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks;

import java.util.HashMap;
import java.util.Map;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StaticPasswordFromMapKeyringConfigCallback
implements KeyringConfigCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticPasswordFromMapKeyringConfigCallback.class);
    private final Map<Long, char[]> keyIdToPassphrase;

    public StaticPasswordFromMapKeyringConfigCallback(Map<Long, char[]> mapSourceKeyIdToPassphrase) {
        this.keyIdToPassphrase = new HashMap<Long, char[]>(mapSourceKeyIdToPassphrase);
    }

    @Override
    public char[] decryptionSecretKeyPassphraseForSecretKeyId(long keyID) {
        char[] password = this.keyIdToPassphrase.get(keyID);
        if (password == null) {
            LOGGER.debug("No passphrase found for keyID 0x{}.", (Object)Long.toHexString(keyID));
        }
        return password;
    }
}

