/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks;

import java.io.IOException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rfc4880KeySelectionStrategy
implements KeySelectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(Rfc4880KeySelectionStrategy.class);
    private final Instant dateOfTimestampVerification;

    protected Instant getDateOfTimestampVerification() {
        return this.dateOfTimestampVerification;
    }

    public Rfc4880KeySelectionStrategy(Instant dateOfTimestampVerification) {
        this.dateOfTimestampVerification = dateOfTimestampVerification;
    }

    protected Set<PGPPublicKeyRing> publicKeyRingsForUid(KeySelectionStrategy.PURPOSE purpose, String uid, KeyringConfig keyringConfig) throws IOException, PGPException {
        HashSet<PGPPublicKeyRing> keyringsForUid = new HashSet<PGPPublicKeyRing>();
        boolean uidAlreadyInBrackets = uid.matches(".*<.*>.*");
        String uidQuery = uidAlreadyInBrackets ? uid : "<" + uid + ">";
        Iterator<PGPPublicKeyRing> keyRings = keyringConfig.getPublicKeyRings().getKeyRings(uidQuery, true, true);
        while (keyRings.hasNext()) {
            keyringsForUid.add(keyRings.next());
        }
        return keyringsForUid;
    }

    @Override
    public Set<PGPPublicKey> validPublicKeysForVerifyingSignatures(String uid, KeyringConfig keyringConfig) throws PGPException, IOException {
        Set<PGPPublicKeyRing> publicKeyrings = this.publicKeyRingsForUid(KeySelectionStrategy.PURPOSE.FOR_SIGNING, uid, keyringConfig);
        return publicKeyrings.stream().flatMap(keyring -> StreamSupport.stream(keyring.spliterator(), false)).filter(this::isVerificationKey).filter(this::isNotRevoked).filter(this::isNotExpired).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public PGPPublicKey selectPublicKey(KeySelectionStrategy.PURPOSE purpose, String uid, KeyringConfig keyringConfig) throws PGPException, IOException {
        Set<PGPPublicKeyRing> publicKeyrings = this.publicKeyRingsForUid(purpose, uid, keyringConfig);
        PGPSecretKeyRingCollection secretKeyRings = keyringConfig.getSecretKeyRings();
        switch (purpose) {
            case FOR_SIGNING: {
                return publicKeyrings.stream().flatMap(keyring -> StreamSupport.stream(keyring.spliterator(), false)).filter(this::isVerificationKey).filter(this::isNotRevoked).filter(this::isNotExpired).filter(this.hasPrivateKey(secretKeyRings)).reduce((a, b) -> b).orElse(null);
            }
            case FOR_ENCRYPTION: {
                return publicKeyrings.stream().flatMap(keyring -> StreamSupport.stream(keyring.spliterator(), false)).filter(this::isEncryptionKey).filter(this::isNotRevoked).filter(this::isNotExpired).reduce((a, b) -> b).orElse(null);
            }
        }
        return null;
    }

    protected Predicate<PGPPublicKey> hasPrivateKey(PGPSecretKeyRingCollection secretKeyRings) {
        return pubKey -> {
            try {
                boolean hasPrivateKey = secretKeyRings.contains(pubKey.getKeyID());
                if (!hasPrivateKey) {
                    LOGGER.trace("Skipping pubkey {} (no private key found)", (Object)Long.toHexString(pubKey.getKeyID()));
                }
                return hasPrivateKey;
            }
            catch (PGPException e) {
                LOGGER.debug("Failed to test for private key for pubkey " + pubKey.getKeyID());
                return false;
            }
        };
    }

    protected boolean isNotMasterKey(PGPPublicKey pubKey) {
        return !pubKey.isMasterKey();
    }

    protected boolean isNotExpired(PGPPublicKey pubKey) {
        return !this.isExpired(pubKey);
    }

    protected boolean isExpired(PGPPublicKey pubKey) {
        boolean isExpired;
        boolean hasExpiryDate;
        boolean bl = hasExpiryDate = pubKey.getValidSeconds() > 0L;
        if (hasExpiryDate) {
            Instant expiryDate = pubKey.getCreationTime().toInstant().plusSeconds(pubKey.getValidSeconds());
            isExpired = expiryDate.isBefore(this.getDateOfTimestampVerification());
            if (isExpired) {
                LOGGER.trace("Skipping pubkey {} (expired since {})", (Object)Long.toHexString(pubKey.getKeyID()), (Object)expiryDate.toString());
            }
        } else {
            isExpired = false;
        }
        return isExpired;
    }

    protected boolean isEncryptionKey(PGPPublicKey publicKey) {
        long keyFlags = this.extractPublicKeyFlags(publicKey);
        boolean canEncryptCommunication = (keyFlags & 4L) == 4L;
        boolean canEncryptStorage = (keyFlags & 8L) == 8L;
        return canEncryptCommunication || canEncryptStorage;
    }

    protected boolean isVerificationKey(PGPPublicKey pubKey) {
        boolean isVerficationKey;
        boolean bl = isVerficationKey = (this.extractPublicKeyFlags(pubKey) & 2L) == 2L;
        if (!isVerficationKey) {
            LOGGER.trace("Skipping pubkey {} (no signing key)", (Object)Long.toHexString(pubKey.getKeyID()));
        }
        return isVerficationKey;
    }

    public boolean isRevoked(PGPPublicKey pubKey) {
        boolean hasRevocation = pubKey.hasRevocation();
        if (hasRevocation) {
            LOGGER.trace("Skipping pubkey {} (revoked)", (Object)Long.toHexString(pubKey.getKeyID()));
        }
        return hasRevocation;
    }

    protected boolean isNotRevoked(PGPPublicKey publicKey) {
        return !this.isRevoked(publicKey);
    }

    protected long extractPublicKeyFlags(PGPPublicKey publicKey) {
        long aggregatedKeyFlags = 0L;
        Iterator directKeySignatures = publicKey.getSignatures();
        while (directKeySignatures.hasNext()) {
            PGPSignature signature = (PGPSignature)directKeySignatures.next();
            PGPSignatureSubpacketVector hashedSubPackets = signature.getHashedSubPackets();
            int keyFlags = hashedSubPackets.getKeyFlags();
            aggregatedKeyFlags |= (long)keyFlags;
        }
        return aggregatedKeyFlags;
    }
}

