/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class Pre202KeySelectionStrategy
implements KeySelectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pre202KeySelectionStrategy.class);

    @Override
    @Nullable
    public PGPPublicKey selectPublicKey(KeySelectionStrategy.PURPOSE purpose, String uid, KeyringConfig keyringConfig) throws PGPException, IOException {
        Iterator<PGPPublicKeyRing> keyRings = keyringConfig.getPublicKeyRings().getKeyRings(uid, true, true);
        if (!keyRings.hasNext()) {
            return null;
        }
        PGPPublicKeyRing publicKeyRing = keyRings.next();
        switch (purpose) {
            case FOR_SIGNING: {
                return Pre202KeySelectionStrategy.extractSigningPublicKey(publicKeyRing);
            }
            case FOR_ENCRYPTION: {
                return Pre202KeySelectionStrategy.getEncryptionKey(publicKeyRing);
            }
        }
        return null;
    }

    @Override
    public Set<PGPPublicKey> validPublicKeysForVerifyingSignatures(String uid, KeyringConfig keyringConfig) throws PGPException, IOException {
        Iterator<PGPPublicKeyRing> keyRings = keyringConfig.getPublicKeyRings().getKeyRings(uid, true, true);
        if (!keyRings.hasNext()) {
            return Collections.EMPTY_SET;
        }
        PGPPublicKey pgpPublicKey = Pre202KeySelectionStrategy.extractSigningPublicKey(keyRings.next());
        HashSet<PGPPublicKey> hashSet = new HashSet<PGPPublicKey>();
        hashSet.add(pgpPublicKey);
        return hashSet;
    }

    @Nullable
    private static PGPPublicKey extractSigningPublicKey(PGPPublicKeyRing keyring) {
        int highestScore = Integer.MIN_VALUE;
        PGPPublicKey ret = null;
        for (PGPPublicKey pubKey : keyring) {
            int score = Pre202KeySelectionStrategy.calculateSigningKeyScore(pubKey);
            if (score <= highestScore) continue;
            ret = pubKey;
            highestScore = score;
        }
        return ret;
    }

    private static int calculateSigningKeyScore(PGPPublicKey pubKey) {
        int score = 0;
        if (!pubKey.isMasterKey()) {
            score += 100;
        }
        if (!pubKey.isEncryptionKey()) {
            score += 10;
        }
        return score;
    }

    static PGPSecretKey extractSecretSigningKeyFromKeyrings(PGPSecretKeyRingCollection pgpSec, String signingKeyUid) throws PGPException {
        int highestScore = Integer.MIN_VALUE;
        PGPSecretKey key = null;
        Iterator<PGPSecretKeyRing> ringIterator = pgpSec.getKeyRings("<" + signingKeyUid + ">", true);
        while (ringIterator.hasNext()) {
            PGPSecretKeyRing kRing = ringIterator.next();
            Iterator<PGPSecretKey> secretKeyIterator = kRing.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = secretKeyIterator.next();
                int score = Pre202KeySelectionStrategy.calculateSigningKeyScore(secretKey.getPublicKey());
                if (!secretKey.isSigningKey() || score <= highestScore) continue;
                key = secretKey;
                highestScore = score;
            }
        }
        if (key == null) {
            throw new PGPException(String.format("Can't find signing key for uid '%s' in key ring.", signingKeyUid));
        }
        LOGGER.trace("Extracted secret signing key for UID '{}'.", (Object)signingKeyUid);
        return key;
    }

    @Nullable
    private static PGPPublicKey getEncryptionKey(PGPPublicKeyRing publicKeyRing) {
        int highestScore = Integer.MIN_VALUE;
        PGPPublicKey returnKey = null;
        for (PGPPublicKey pubKey : publicKeyRing) {
            int score = Pre202KeySelectionStrategy.calculateEncryptionKeyScore(pubKey);
            if (score <= highestScore) continue;
            returnKey = pubKey;
            highestScore = score;
        }
        return returnKey;
    }

    private static int calculateEncryptionKeyScore(PGPPublicKey pubKey) {
        if (!pubKey.isEncryptionKey()) {
            return Integer.MIN_VALUE;
        }
        int score = 0;
        if (!pubKey.isMasterKey()) {
            ++score;
        }
        return score;
    }
}

