/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PGPUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPUtilities.class);

    private PGPUtilities() {
    }

    @Nullable
    public static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pgpSec, long keyID, char[] pass) throws PGPException {
        LOGGER.debug("Finding secret key with key ID '0x{}'", (Object)Long.toHexString(keyID));
        PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
        if (pgpSecKey == null) {
            return null;
        }
        return PGPUtilities.extractPrivateKey(pgpSecKey, pass);
    }

    public static PGPPrivateKey extractPrivateKey(PGPSecretKey encryptedKey, char[] passphrase) throws PGPException {
        LOGGER.trace("Extracting secret key with key ID '0x{}'", (Object)Long.toHexString(encryptedKey.getKeyID()));
        PGPDigestCalculatorProvider calcProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build();
        PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder(calcProvider).setProvider("BC").build(passphrase);
        return encryptedKey.extractPrivateKey(decryptor);
    }

    public static PGPPublicKeyRing extractPublicKeyRingForUserId(String publicKeyUid, PGPPublicKeyRingCollection publicKeyRings) throws PGPException {
        if (publicKeyUid == null) {
            throw new IllegalArgumentException("publicKeyUid must not be null");
        }
        if (publicKeyRings == null) {
            throw new IllegalArgumentException("publicKeyRings must not be null");
        }
        Iterator<PGPPublicKeyRing> keyRings = publicKeyRings.getKeyRings("<" + publicKeyUid + ">", true);
        PGPPublicKeyRing returnKeyRing = null;
        while (keyRings.hasNext()) {
            PGPPublicKeyRing currentKeyRing = keyRings.next();
            if (!(currentKeyRing instanceof PGPPublicKeyRing)) continue;
            if (returnKeyRing == null) {
                returnKeyRing = currentKeyRing;
                continue;
            }
            throw new PGPException("Multiple public key rings found for UID '" + publicKeyUid + "'!");
        }
        if (returnKeyRing == null) {
            throw new PGPException("No public key ring found for UID '" + publicKeyUid + "'!");
        }
        LOGGER.debug("Extracted public key ring for UID '{}' with key strength {}.", (Object)publicKeyUid, (Object)returnKeyRing.getPublicKey().getBitStrength());
        return returnKeyRing;
    }
}

