/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms;

public enum PGPHashAlgorithms {
    MD5(1, true),
    SHA1(2, true),
    SHA_224(11),
    SHA_256(8),
    SHA_384(9),
    SHA_512(10),
    RIPEMD160(3),
    TIGER_192(6),
    HAVAL_5_160(7, true);

    private final int algorithmId;
    private final boolean insecure;

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    private PGPHashAlgorithms(int algorithmId) {
        this(algorithmId, false);
    }

    private PGPHashAlgorithms(int algorithmId, boolean insecure) {
        this.algorithmId = algorithmId;
        this.insecure = insecure;
    }
}

