/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.DefaultPGPAlgorithmSuites;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPAlgorithmSuite;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.encrypting.PGPEncryptingStream;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.Rfc4880KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildEncryptionOutputStreamAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildEncryptionOutputStreamAPI.class);
    private OutputStream sinkForEncryptedData;
    private KeyringConfig encryptionConfig;
    private PGPAlgorithmSuite algorithmSuite;
    private KeySelectionStrategy keySelectionStrategy;
    @Nullable
    private String signWith;
    private Set<PGPPublicKey> recipients;
    private boolean armorOutput;

    public WithKeySelectionStrategy withConfig(KeyringConfig encryptionConfig) throws IOException, PGPException {
        if (encryptionConfig == null) {
            throw new IllegalArgumentException("encryptionConfig must not be null");
        }
        if (encryptionConfig.getKeyFingerPrintCalculator() == null) {
            throw new IllegalArgumentException("encryptionConfig.getKeyFingerPrintCalculator() must not be null");
        }
        if (encryptionConfig.getPublicKeyRings() == null) {
            throw new IllegalArgumentException("encryptionConfig.getPublicKeyRings() must not be null");
        }
        this.encryptionConfig = encryptionConfig;
        return new WithKeySelectionStrategy();
    }

    private class WithAlgorithmSuiteImpl
    implements WithAlgorithmSuite {
        private WithAlgorithmSuiteImpl() {
        }

        @Override
        public WithAlgorithmSuite.To withDefaultAlgorithms() {
            BuildEncryptionOutputStreamAPI.this.algorithmSuite = DefaultPGPAlgorithmSuites.defaultSuiteForGnuPG();
            LOGGER.trace("use algorithms {}", (Object)BuildEncryptionOutputStreamAPI.this.algorithmSuite.toString());
            return new ToImpl();
        }

        @Override
        public WithAlgorithmSuite.To withStrongAlgorithms() {
            BuildEncryptionOutputStreamAPI.this.algorithmSuite = DefaultPGPAlgorithmSuites.strongSuite();
            LOGGER.trace("use algorithms {}", (Object)BuildEncryptionOutputStreamAPI.this.algorithmSuite.toString());
            return new ToImpl();
        }

        @Override
        public WithAlgorithmSuite.To withAlgorithms(PGPAlgorithmSuite algorithmSuite) {
            if (algorithmSuite == null) {
                throw new IllegalArgumentException("algorithmSuite must not be null");
            }
            BuildEncryptionOutputStreamAPI.this.algorithmSuite = algorithmSuite;
            LOGGER.trace("use algorithms {}", (Object)BuildEncryptionOutputStreamAPI.this.algorithmSuite.toString());
            return new ToImpl();
        }

        final class ToImpl
        implements WithAlgorithmSuite.To {
            ToImpl() {
            }

            private PGPPublicKey extractValidKey(String recipient) throws PGPException {
                if (recipient == null || recipient.isEmpty()) {
                    throw new IllegalArgumentException("recipient must be a string");
                }
                try {
                    PGPPublicKey recipientEncryptionKey = BuildEncryptionOutputStreamAPI.this.keySelectionStrategy.selectPublicKey(KeySelectionStrategy.PURPOSE.FOR_ENCRYPTION, recipient, BuildEncryptionOutputStreamAPI.this.encryptionConfig);
                    if (recipientEncryptionKey == null) {
                        throw new PGPException("No (suitable) public key for encryption to " + recipient + " found");
                    }
                    LOGGER.trace("encrypt to recipient {} using key 0x{}", (Object)recipient, (Object)Long.toHexString(recipientEncryptionKey.getKeyID()));
                    return recipientEncryptionKey;
                }
                catch (IOException e) {
                    throw new PGPException("Failed to load keys", e);
                }
            }

            @Override
            public WithAlgorithmSuite.To.SignWith toRecipient(String recipient) throws PGPException {
                BuildEncryptionOutputStreamAPI.this.recipients = new HashSet();
                BuildEncryptionOutputStreamAPI.this.recipients.add(this.extractValidKey(recipient));
                return new SignWithImpl();
            }

            @Override
            public WithAlgorithmSuite.To.SignWith toRecipients(String ... recipients) throws PGPException {
                BuildEncryptionOutputStreamAPI.this.recipients = new HashSet();
                for (String recipient : recipients) {
                    BuildEncryptionOutputStreamAPI.this.recipients.add(this.extractValidKey(recipient));
                }
                return new SignWithImpl();
            }

            final class SignWithImpl
            implements WithAlgorithmSuite.To.SignWith {
                SignWithImpl() {
                }

                @Override
                public WithAlgorithmSuite.To.SignWith.Armor andSignWith(String userId) throws IOException, PGPException {
                    if (BuildEncryptionOutputStreamAPI.this.encryptionConfig.getSecretKeyRings() == null) {
                        throw new IllegalArgumentException("encryptionConfig.getSecretKeyRings() must not be null");
                    }
                    PGPPublicKey signingKeyPubKey = BuildEncryptionOutputStreamAPI.this.keySelectionStrategy.selectPublicKey(KeySelectionStrategy.PURPOSE.FOR_SIGNING, userId, BuildEncryptionOutputStreamAPI.this.encryptionConfig);
                    if (signingKeyPubKey == null) {
                        throw new PGPException("No (suitable) public key for signing with '" + userId + "' found");
                    }
                    PGPSecretKey signingKey = BuildEncryptionOutputStreamAPI.this.encryptionConfig.getSecretKeyRings().getSecretKey(signingKeyPubKey.getKeyID());
                    if (signingKey == null) {
                        throw new PGPException("No (suitable) secret key for signing with " + userId + " found (public key exists!)");
                    }
                    BuildEncryptionOutputStreamAPI.this.signWith = userId;
                    LOGGER.trace("sign with {}", (Object)BuildEncryptionOutputStreamAPI.this.signWith);
                    return new ArmorImpl();
                }

                @Override
                public WithAlgorithmSuite.To.SignWith.Armor andDoNotSign() {
                    BuildEncryptionOutputStreamAPI.this.signWith = null;
                    LOGGER.trace("do not sign ");
                    return new ArmorImpl();
                }

                public final class ArmorImpl
                implements WithAlgorithmSuite.To.SignWith.Armor {
                    @Override
                    public Build binaryOutput() {
                        BuildEncryptionOutputStreamAPI.this.armorOutput = false;
                        LOGGER.trace("binary output");
                        return new Builder();
                    }

                    @Override
                    public Build armorAsciiOutput() {
                        BuildEncryptionOutputStreamAPI.this.armorOutput = true;
                        LOGGER.trace("ascii armor output");
                        return new Builder();
                    }

                    public final class Builder
                    implements Build {
                        @Override
                        public OutputStream andWriteTo(OutputStream sinkForEncryptedData) throws PGPException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
                            BuildEncryptionOutputStreamAPI.this.sinkForEncryptedData = sinkForEncryptedData;
                            OutputStream outputStream = PGPEncryptingStream.create(BuildEncryptionOutputStreamAPI.this.encryptionConfig, BuildEncryptionOutputStreamAPI.this.algorithmSuite, BuildEncryptionOutputStreamAPI.this.signWith, BuildEncryptionOutputStreamAPI.this.sinkForEncryptedData, BuildEncryptionOutputStreamAPI.this.keySelectionStrategy, BuildEncryptionOutputStreamAPI.this.armorOutput, BuildEncryptionOutputStreamAPI.this.recipients);
                            return outputStream;
                        }
                    }
                }
            }
        }
    }

    public static interface WithAlgorithmSuite {
        public To withDefaultAlgorithms();

        public To withStrongAlgorithms();

        public To withAlgorithms(PGPAlgorithmSuite var1);

        public static interface To {
            public SignWith toRecipient(String var1) throws PGPException;

            public SignWith toRecipients(String ... var1) throws PGPException;

            public static interface SignWith {
                public Armor andSignWith(String var1) throws IOException, PGPException;

                public Armor andDoNotSign();

                public static interface Armor {
                    public Build binaryOutput();

                    public Build armorAsciiOutput();
                }
            }
        }
    }

    public static interface Build {
        public OutputStream andWriteTo(OutputStream var1) throws PGPException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, IOException;
    }

    public final class WithKeySelectionStrategy
    extends WithAlgorithmSuiteImpl {
        private WithKeySelectionStrategy() {
            BuildEncryptionOutputStreamAPI.this.keySelectionStrategy = new Rfc4880KeySelectionStrategy(Instant.now());
        }

        public WithAlgorithmSuite setReferenceDateForKeyValidityTo(Instant dateOfTimestampVerification) {
            if (dateOfTimestampVerification == null) {
                throw new IllegalArgumentException("dateOfTimestampVerification must not be null");
            }
            BuildEncryptionOutputStreamAPI.this.keySelectionStrategy = new Rfc4880KeySelectionStrategy(dateOfTimestampVerification);
            LOGGER.trace("WithKeySelectionStrategy: setReferenceDateForKeyValidityTo {}", (Object)dateOfTimestampVerification);
            return new WithAlgorithmSuiteImpl();
        }

        public WithAlgorithmSuite withKeySelectionStrategy(KeySelectionStrategy strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException("strategy must not be null");
            }
            BuildEncryptionOutputStreamAPI.this.keySelectionStrategy = strategy;
            LOGGER.trace("WithKeySelectionStrategy: override strategy to {}", (Object)strategy.getClass().toGenericString());
            return new WithAlgorithmSuiteImpl();
        }
    }
}

