/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.decrypting.DecryptionStreamFactory;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.Rfc4880KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategies;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;

public final class BuildDecryptionInputStreamAPI {
    @Nonnull
    private KeyringConfig keyringConfig;
    @Nonnull
    private SignatureValidationStrategy signatureCheckingMode;
    private KeySelectionStrategy keySelectionStrategy = new Rfc4880KeySelectionStrategy(Instant.now());

    @Nonnull
    public ValidationWithKeySelectionStrategy withConfig(@Nullable KeyringConfig keyringConfig) {
        if (keyringConfig == null) {
            throw new IllegalArgumentException("keyringConfig must not be null");
        }
        this.keyringConfig = keyringConfig;
        return new ValidationWithKeySelectionStrategy();
    }

    private class ValidationImpl
    implements Validation {
        private ValidationImpl() {
        }

        @Override
        @Nonnull
        public Build andRequireSignatureFromAllKeys(Long ... publicKeyIds) {
            if (publicKeyIds == null || publicKeyIds.length == 0) {
                throw new IllegalArgumentException("publicKeyIds must not be null or empty");
            }
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireSignatureFromAllKeys(publicKeyIds);
            return new Builder();
        }

        @Override
        @Nonnull
        public Build andRequireSignatureFromAllKeys(String ... userIds) throws PGPException, IOException {
            if (userIds == null || userIds.length == 0) {
                throw new IllegalArgumentException("userIds must not be null or empty");
            }
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireSignatureFromAllUids(BuildDecryptionInputStreamAPI.this.keySelectionStrategy, BuildDecryptionInputStreamAPI.this.keyringConfig, userIds);
            return new Builder();
        }

        @Override
        @Nonnull
        public Build andValidateSomeoneSigned() {
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireAnySignature();
            return new Builder();
        }

        @Override
        @Nonnull
        public Build andIgnoreSignatures() {
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.ignoreSignatures();
            return new Builder();
        }

        public final class Builder
        implements Build {
            @Override
            @Nonnull
            public InputStream fromEncryptedInputStream(@Nullable InputStream encryptedData) throws IOException, NoSuchProviderException {
                if (encryptedData == null) {
                    throw new IllegalArgumentException("encryptedData must not be null");
                }
                DecryptionStreamFactory pgpInputStreamFactory = DecryptionStreamFactory.create(BuildDecryptionInputStreamAPI.this.keyringConfig, BuildDecryptionInputStreamAPI.this.signatureCheckingMode);
                return pgpInputStreamFactory.wrapWithDecryptAndVerify(encryptedData);
            }
        }
    }

    public static interface Validation {
        @Nonnull
        public Build andRequireSignatureFromAllKeys(Long ... var1);

        @Nonnull
        public Build andRequireSignatureFromAllKeys(String ... var1) throws PGPException, IOException;

        @Nonnull
        public Build andValidateSomeoneSigned();

        @Nonnull
        public Build andIgnoreSignatures();
    }

    public static interface Build {
        @Nonnull
        public InputStream fromEncryptedInputStream(@Nullable InputStream var1) throws IOException, NoSuchProviderException;
    }

    public final class ValidationWithKeySelectionStrategy
    extends ValidationImpl {
        ValidationWithKeySelectionStrategy() {
            BuildDecryptionInputStreamAPI.this.keySelectionStrategy = new Rfc4880KeySelectionStrategy(Instant.now());
        }

        public Validation setReferenceDateForKeyValidityTo(Instant dateOfTimestampVerification) {
            if (dateOfTimestampVerification == null) {
                throw new IllegalArgumentException("dateOfTimestampVerification must not be null");
            }
            BuildDecryptionInputStreamAPI.this.keySelectionStrategy = new Rfc4880KeySelectionStrategy(dateOfTimestampVerification);
            return new ValidationImpl();
        }

        public Validation withKeySelectionStrategy(KeySelectionStrategy strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException("strategy must not be null");
            }
            BuildDecryptionInputStreamAPI.this.keySelectionStrategy = strategy;
            return new ValidationImpl();
        }
    }
}

