/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.freetts.mbrola;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class MbrolaCaller
implements UtteranceProcessor {
    private String[] cmd;
    private long closeDelay = 0L;

    public MbrolaCaller(String[] cmd) {
        this.cmd = cmd;
        this.closeDelay = Utilities.getLong("de.dfki.lt.freetts.mbrola.MbrolaCaller.closeDelay", 100L);
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        Process process;
        Relation segmentRelation = utterance.getRelation("Segment");
        Item segment = segmentRelation.getHead();
        if (segment == null) {
            return;
        }
        try {
            process = Runtime.getRuntime().exec(this.cmd);
        }
        catch (Exception e) {
            throw new ProcessException("Cannot start mbrola program: " + this.cmd);
        }
        PrintWriter toMbrola = new PrintWriter(process.getOutputStream());
        BufferedInputStream fromMbrola = new BufferedInputStream(process.getInputStream());
        while (segment != null) {
            String name = segment.getFeatures().getString("name");
            int dur = segment.getFeatures().getInt("mbr_dur");
            String targets = segment.getFeatures().getString("mbr_targets");
            String output = name + " " + dur + " " + targets;
            toMbrola.println(output);
            segment = segment.getNext();
        }
        toMbrola.flush();
        if (this.closeDelay > 0L) {
            try {
                Thread.sleep(this.closeDelay);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        toMbrola.close();
        byte[] buffer = new byte[1024];
        ArrayList<byte[]> audioData = new ArrayList<byte[]>();
        int totalSize = 0;
        int nrRead = -1;
        try {
            while ((nrRead = fromMbrola.read(buffer)) != -1) {
                if (nrRead < buffer.length) {
                    byte[] slice = new byte[nrRead];
                    System.arraycopy(buffer, 0, slice, 0, nrRead);
                    audioData.add(slice);
                } else {
                    audioData.add(buffer);
                    buffer = new byte[buffer.length];
                }
                totalSize += nrRead;
            }
            fromMbrola.close();
        }
        catch (IOException e) {
            throw new ProcessException("Cannot read from mbrola");
        }
        if (totalSize == 0) {
            throw new ProcessException("No audio data read");
        }
        utterance.setObject("mbrolaAudio", audioData);
        utterance.setInt("mbrolaAudioLength", totalSize);
    }

    public String toString() {
        return "MbrolaCaller";
    }
}

