/*
 * Decompiled with CFR 0.152.
 */
package com.voicerss.tts;

import com.voicerss.tts.SpeechDataEvent;
import com.voicerss.tts.SpeechDataEventListener;
import com.voicerss.tts.SpeechErrorEvent;
import com.voicerss.tts.SpeechErrorEventListener;
import com.voicerss.tts.VoiceParameters;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoiceProvider {
    private ArrayList<SpeechErrorEventListener> _speechErrorListeners = new ArrayList();
    private ArrayList<SpeechDataEventListener> _speechDataListeners = new ArrayList();
    private String _apiKey;
    private Boolean _ssl;

    public VoiceProvider(String apiKey) {
        this._apiKey = apiKey;
        this._ssl = false;
    }

    public VoiceProvider(String apiKey, Boolean ssl) {
        this(apiKey);
        this._ssl = ssl;
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public void setApiKey(String value) {
        this._apiKey = value;
    }

    public Boolean getSSL() {
        return this._ssl;
    }

    public void setSSL(Boolean value) {
        this._ssl = value;
    }

    public synchronized void addSpeechErrorEventListener(SpeechErrorEventListener listener) {
        this._speechErrorListeners.add(listener);
    }

    public synchronized void removeSpeechErrorEventListener(SpeechErrorEventListener listener) {
        this._speechErrorListeners.remove(listener);
    }

    public synchronized void addSpeechDataEventListener(SpeechDataEventListener listener) {
        this._speechDataListeners.add(listener);
    }

    public synchronized void removeSpeechDataEventListener(SpeechDataEventListener listener) {
        this._speechDataListeners.remove(listener);
    }

    private void handleSpeechError(Exception exception) {
        if (exception != null && this._speechErrorListeners != null) {
            for (SpeechErrorEventListener _listener : this._speechErrorListeners) {
                _listener.handleSpeechErrorEvent(new SpeechErrorEvent(exception));
            }
        }
    }

    private <T> void handleSpeechData(T data) {
        if (data != null && !data.equals("") && this._speechDataListeners != null) {
            for (SpeechDataEventListener _listener : this._speechDataListeners) {
                _listener.handleSpeechDataEvent(new SpeechDataEvent<T>(data));
            }
        }
    }

    public <T> T speech(VoiceParameters params) throws Exception {
        this.validate(params);
        URL url = new URL(String.valueOf(this._ssl != false ? "https" : "http") + "://api.voicerss.org/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        conn.setConnectTimeout(60000);
        conn.setDoOutput(true);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, "UTF-8"));
        writer.write(this.buildParameters(params));
        writer.close();
        outStream.close();
        if (conn.getResponseCode() != 200) {
            throw new Exception(conn.getResponseMessage());
        }
        ByteArrayOutputStream outArray = new ByteArrayOutputStream();
        InputStream inStream = conn.getInputStream();
        byte[] buffer = new byte[4096];
        int n = -1;
        while ((n = inStream.read(buffer)) > 0) {
            outArray.write(buffer, 0, n);
        }
        byte[] response = outArray.toByteArray();
        inStream.close();
        String responseString = new String(response, "UTF-8");
        if (responseString.indexOf("ERROR") == 0) {
            throw new Exception(responseString);
        }
        return (T)(params.getBase64() != false ? responseString : (Object)response);
    }

    public void speechAsync(final VoiceParameters params) {
        try {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Object response = VoiceProvider.this.speech(params);
                        if (params.getBase64().booleanValue()) {
                            VoiceProvider.this.handleSpeechData((String)response);
                        } else {
                            VoiceProvider.this.handleSpeechData((byte[])response);
                        }
                    }
                    catch (Exception e) {
                        VoiceProvider.this.handleSpeechError(e);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            this.handleSpeechError(e);
        }
    }

    private void validate(VoiceParameters params) throws Exception {
        if (this._apiKey == null || this._apiKey.trim().equals("")) {
            throw new Exception("The API key is undefined");
        }
        if (params.getText() == null || params.getText().trim().equals("")) {
            throw new Exception("The text is undefined");
        }
        if (params.getLanguage() == null || params.getLanguage().trim().equals("")) {
            throw new Exception("The language is undefined");
        }
    }

    private String buildParameters(VoiceParameters params) {
        StringBuilder sb = new StringBuilder();
        sb.append("key=" + (this._apiKey != null ? this._apiKey : ""));
        sb.append("&src=" + (params.getText() != null ? params.getText() : ""));
        sb.append("&hl=" + (params.getLanguage() != null ? params.getLanguage() : ""));
        sb.append("&r=" + (params.getRate() != null ? params.getRate() : ""));
        sb.append("&c=" + (params.getCodec() != null ? params.getCodec() : ""));
        sb.append("&f=" + (params.getFormat() != null ? params.getFormat() : ""));
        sb.append("&ssml=" + (params.getSSML() != null ? params.getSSML() : ""));
        sb.append("&b64=" + (params.getBase64() != null ? params.getBase64() : ""));
        return sb.toString();
    }
}

