/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Timer;
import com.sun.speech.freetts.util.Utilities;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class JavaStreamingAudioPlayer
implements AudioPlayer {
    private volatile boolean paused;
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private SourceDataLine line = null;
    private float volume = 1.0f;
    private long timeOffset = 0L;
    private BulkTimer timer = new BulkTimer();
    private AudioFormat defaultFormat;
    private AudioFormat currentFormat = this.defaultFormat = new AudioFormat(8000.0f, 16, 1, true, true);
    private boolean debug = false;
    private boolean audioMetrics = false;
    private boolean firstSample = true;
    private long cancelDelay;
    private long drainDelay;
    private long openFailDelayMs;
    private long totalOpenFailDelayMs;
    private Object openLock = new Object();
    private Object lineLock = new Object();
    private static final int AUDIO_BUFFER_SIZE = Utilities.getInteger("com.sun.speech.freetts.audio.AudioPlayer.bufferSize", 8192);
    private static final int BYTES_PER_WRITE = Utilities.getInteger("com.sun.speech.freetts.audio.AudioPlayer.bytesPerWrite", 160);

    public JavaStreamingAudioPlayer() {
        this.debug = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.debug");
        this.cancelDelay = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.cancelDelay", 0L);
        this.drainDelay = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.drainDelay", 150L);
        this.openFailDelayMs = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.openFailDelayMs", 0L);
        this.totalOpenFailDelayMs = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.totalOpenFailDelayMs", 0L);
        this.audioMetrics = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.showAudioMetrics");
        this.setPaused(false);
    }

    @Override
    public synchronized void setAudioFormat(AudioFormat format) {
        this.currentFormat = format;
        this.debugPrint("AF changed to " + format);
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    @Override
    public void startFirstSampleTimer() {
        this.timer.start("firstAudio");
        this.firstSample = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openLine(AudioFormat format) {
        Object object = this.lineLock;
        synchronized (object) {
            if (this.line != null) {
                this.line.close();
                this.line = null;
            }
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        boolean opened = false;
        long totalDelayMs = 0L;
        do {
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.addLineListener(new JavaStreamLineListener());
                Object object2 = this.openLock;
                synchronized (object2) {
                    this.line.open(format, AUDIO_BUFFER_SIZE);
                    try {
                        this.openLock.wait();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    opened = true;
                }
            }
            catch (LineUnavailableException lue) {
                System.err.println("LINE UNAVAILABLE: Format is " + this.currentFormat);
                try {
                    Thread.sleep(this.openFailDelayMs);
                    totalDelayMs += this.openFailDelayMs;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        } while (!opened && totalDelayMs < this.totalOpenFailDelayMs);
        if (opened) {
            this.setVolume(this.line, this.volume);
            this.resetTime();
            if (this.isPaused() && this.line.isRunning()) {
                this.line.stop();
            } else {
                this.line.start();
            }
        } else {
            if (this.line != null) {
                this.line.close();
            }
            this.line = null;
        }
    }

    @Override
    public synchronized void pause() {
        if (!this.isPaused()) {
            this.setPaused(true);
            if (this.line != null) {
                this.line.stop();
            }
        }
    }

    @Override
    public synchronized void resume() {
        if (this.isPaused()) {
            this.setPaused(false);
            if (!this.isCancelled() && this.line != null) {
                this.line.start();
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.debugPrint("cancelling...");
        if (this.audioMetrics) {
            this.timer.start("audioCancel");
        }
        if (this.cancelDelay > 0L) {
            try {
                Thread.sleep(this.cancelDelay);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        Object object = this.lineLock;
        synchronized (object) {
            if (this.line != null && this.line.isRunning()) {
                this.line.stop();
                this.line.flush();
            }
        }
        object = this;
        synchronized (object) {
            this.cancelled = true;
            this.notify();
        }
        if (this.audioMetrics) {
            this.timer.stop("audioCancel");
            Timer.showTimesShortTitle("");
            this.timer.getTimer("audioCancel").showTimesShort(0L);
        }
        this.debugPrint("...cancelled");
    }

    @Override
    public synchronized void reset() {
        this.timer.start("audioOut");
        if (this.line != null) {
            this.waitResume();
            if (this.isCancelled() && !this.isDone()) {
                this.cancelled = false;
                this.line.start();
            }
        }
    }

    @Override
    public synchronized void close() {
        this.done = true;
        if (this.line != null && this.line.isOpen()) {
            this.line.close();
            this.line = null;
            this.notify();
        }
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float volume) {
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        this.volume = volume;
    }

    private void setPaused(boolean state) {
        this.paused = state;
    }

    private boolean isPaused() {
        return this.paused;
    }

    private void setVolume(SourceDataLine line, float vol) {
        if (line != null && line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl volumeControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
            float range = volumeControl.getMaximum() - volumeControl.getMinimum();
            volumeControl.setValue(vol * range + volumeControl.getMinimum());
        }
    }

    @Override
    public void begin(int size) {
        this.debugPrint("opening Stream...");
        this.openLine(this.currentFormat);
        this.reset();
        this.debugPrint("...Stream opened");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean end() {
        if (this.line != null) {
            this.drain();
            Object object = this.lineLock;
            synchronized (object) {
                this.line.close();
                this.line = null;
            }
            this.notify();
            this.debugPrint("ended stream...");
        }
        return true;
    }

    @Override
    public boolean drain() {
        if (this.line != null) {
            this.debugPrint("started draining...");
            if (this.line.isOpen()) {
                this.line.drain();
                if (this.drainDelay > 0L) {
                    try {
                        Thread.sleep(this.drainDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.debugPrint("...finished draining");
        }
        this.timer.stop("audioOut");
        return !this.isCancelled();
    }

    @Override
    public synchronized long getTime() {
        return (this.line.getMicrosecondPosition() - this.timeOffset) / 1000L;
    }

    @Override
    public synchronized void resetTime() {
        this.timeOffset = this.line.getMicrosecondPosition();
    }

    @Override
    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(byte[] bytes, int offset, int size) {
        if (this.line == null) {
            return false;
        }
        int bytesRemaining = size;
        int curIndex = offset;
        if (this.firstSample) {
            this.firstSample = false;
            this.timer.stop("firstAudio");
            if (this.audioMetrics) {
                Timer.showTimesShortTitle("");
                this.timer.getTimer("firstAudio").showTimesShort(0L);
            }
        }
        this.debugPrint(" au write " + bytesRemaining + " pos " + this.line.getMicrosecondPosition() + " avail " + this.line.available() + " bsz " + this.line.getBufferSize());
        while (bytesRemaining > 0 && !this.isCancelled()) {
            int bytesWritten;
            if (!this.waitResume()) {
                return false;
            }
            this.debugPrint("   queueing cur " + curIndex + " br " + bytesRemaining);
            Object object = this.lineLock;
            synchronized (object) {
                bytesWritten = this.line.write(bytes, curIndex, Math.min(BYTES_PER_WRITE, bytesRemaining));
                if (bytesWritten != bytesRemaining) {
                    this.debugPrint("RETRY! bw" + bytesWritten + " br " + bytesRemaining);
                }
            }
            this.debugPrint("   wrote  cur " + (curIndex += bytesWritten) + " br " + (bytesRemaining -= bytesWritten) + " bw " + bytesWritten);
        }
        return !this.isCancelled() && !this.isDone();
    }

    private synchronized boolean waitResume() {
        while (this.isPaused() && !this.isCancelled() && !this.isDone()) {
            try {
                this.debugPrint("   paused waiting ");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.isCancelled() && !this.isDone();
    }

    public String toString() {
        return "JavaStreamingAudioPlayer";
    }

    private void debugPrint(String msg) {
        if (this.debug) {
            System.out.println(this.toString() + ": " + msg);
        }
    }

    @Override
    public void showMetrics() {
        this.timer.show("JavaStreamingAudioPlayer");
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized boolean isDone() {
        return this.done;
    }

    private class JavaStreamLineListener
    implements LineListener {
        private JavaStreamLineListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(LineEvent event) {
            if (event.getType().equals(LineEvent.Type.OPEN)) {
                Object object = JavaStreamingAudioPlayer.this.openLock;
                synchronized (object) {
                    JavaStreamingAudioPlayer.this.openLock.notifyAll();
                }
            }
        }
    }
}

