/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PeripheralBarrel
implements IPlusPlusPeripheral {
    private int MAX_SIZE = 4096;
    private int STACK_SIZE = 64;
    private Item ITEM_TYPE_STORED;
    private int ITEM_META_STORED = 0;
    private int CURRENT_USAGE = 0;
    private ITurtleAccess turtle;
    private TurtleSide side;
    public boolean changed = false;
    private NBTTagCompound itemStoredTag;

    public PeripheralBarrel(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
        NBTTagCompound tag = turtle.getUpgradeNBTData(side);
        if (tag.func_74762_e("maxSize") > 0) {
            this.MAX_SIZE = tag.func_74762_e("maxSize");
        }
        if (tag.func_74762_e("stackSize") > 0) {
            this.STACK_SIZE = tag.func_74762_e("stackSize");
        }
        this.CURRENT_USAGE = tag.func_74762_e("currentUsage");
        if (tag.func_74767_n("isKnown")) {
            this.ITEM_TYPE_STORED = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("itemID")));
            this.ITEM_META_STORED = tag.func_74762_e("stackMeta");
            if (tag.func_74764_b("itemTag")) {
                this.itemStoredTag = tag.func_74775_l("itemTag");
            }
        }
        this.checkUsageStats();
    }

    private void checkUsageStats() {
        if (this.CURRENT_USAGE <= 0 || this.ITEM_TYPE_STORED == null) {
            this.CURRENT_USAGE = 0;
            this.STACK_SIZE = 64;
            this.MAX_SIZE = 64 * this.STACK_SIZE;
            this.ITEM_TYPE_STORED = null;
            this.ITEM_META_STORED = 0;
            this.itemStoredTag = null;
        }
    }

    private String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public String getType() {
        return "barrel";
    }

    public String[] getMethodNames() {
        return new String[]{"get", "put", "getUnlocalizedName", "getLocalizedName", "getItemID", "getAmount", "getOreDictEntries", "getNbtTag"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableBarrelTurtle) {
            throw new LuaException("Barrel Turtles have been disabled");
        }
        if (method == 0) {
            int amount = this.STACK_SIZE;
            if (arguments.length > 0) {
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                amount = (int)((Double)arguments[0]).doubleValue();
            }
            if (this.CURRENT_USAGE < amount) {
                amount = this.CURRENT_USAGE;
            }
            if (this.ITEM_TYPE_STORED == null) {
                return new Object[]{0};
            }
            ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
            Item itemStored = this.ITEM_TYPE_STORED;
            int stackCount = amount;
            if (!slot.func_190926_b()) {
                ItemStack compareStack = new ItemStack(itemStored, stackCount, this.ITEM_META_STORED);
                compareStack.func_77982_d(this.itemStoredTag);
                if (!slot.func_77969_a(compareStack) || !this.areItemStackTagsEqual(slot, compareStack)) {
                    throw new LuaException("Item mismatch");
                }
                if (amount + slot.func_190916_E() > this.STACK_SIZE) {
                    amount = this.STACK_SIZE - slot.func_190916_E();
                }
                stackCount = amount + slot.func_190916_E();
            }
            ItemStack stack = new ItemStack(itemStored, stackCount, this.ITEM_META_STORED);
            stack.func_77982_d(this.itemStoredTag);
            this.CURRENT_USAGE -= amount;
            this.checkUsageStats();
            this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), stack.func_77946_l());
            this.changed = true;
            return new Object[]{amount};
        }
        if (method == 1) {
            int amount = 64;
            if (arguments.length > 0) {
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                amount = (int)((Double)arguments[0]).doubleValue();
            }
            if (this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_190926_b()) {
                return new Object[]{0};
            }
            ItemStack items = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77946_l();
            if (amount > items.func_190916_E()) {
                amount = items.func_190916_E();
            }
            if (amount > this.MAX_SIZE - this.CURRENT_USAGE) {
                amount = this.MAX_SIZE - this.CURRENT_USAGE;
            }
            if (this.ITEM_TYPE_STORED != null) {
                ItemStack temp = new ItemStack(this.ITEM_TYPE_STORED, 1, this.ITEM_META_STORED);
                temp.func_77982_d(this.itemStoredTag);
                if (!temp.func_77969_a(items) || !this.areItemStackTagsEqual(temp, items)) {
                    throw new LuaException("Item mismatch");
                }
            } else {
                Item type;
                this.ITEM_TYPE_STORED = type = items.func_77973_b();
                this.ITEM_META_STORED = items.func_77952_i();
                this.itemStoredTag = items.func_77978_p();
                this.STACK_SIZE = type.getItemStackLimit(items);
                this.MAX_SIZE = 64 * this.STACK_SIZE;
            }
            this.CURRENT_USAGE += amount;
            ItemStack newStack = new ItemStack(items.func_77973_b());
            newStack.func_77964_b(this.ITEM_META_STORED);
            if (items.func_190916_E() - amount <= 0) {
                newStack = ItemStack.field_190927_a;
            } else {
                newStack.func_190920_e(items.func_190916_E() - amount);
            }
            this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), newStack);
            this.changed = true;
            return new Object[]{amount};
        }
        if (method == 2) {
            if (this.ITEM_TYPE_STORED != null) {
                return new Object[]{this.ITEM_TYPE_STORED.func_77658_a()};
            }
        } else if (method == 3) {
            if (this.ITEM_TYPE_STORED != null) {
                return new Object[]{new ItemStack(this.ITEM_TYPE_STORED).func_82833_r()};
            }
        } else if (method == 4) {
            if (this.ITEM_TYPE_STORED != null) {
                return new Object[]{ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.ITEM_TYPE_STORED) != null ? ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.ITEM_TYPE_STORED).toString() : null};
            }
        } else {
            if (method == 5) {
                int amount = 0;
                if (this.ITEM_TYPE_STORED != null) {
                    amount = this.CURRENT_USAGE;
                }
                return new Object[]{amount};
            }
            if (method == 6) {
                int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(this.ITEM_TYPE_STORED));
                HashMap<Integer, String> entries = new HashMap<Integer, String>();
                for (int i = 0; i < ids.length; ++i) {
                    entries.put(i, OreDictionary.getOreName((int)ids[i]));
                }
                return new Object[]{entries};
            }
            if (method == 7 && this.itemStoredTag != null) {
                return new Object[]{this.itemStoredTag.toString()};
            }
        }
        return new Object[0];
    }

    private boolean areItemStackTagsEqual(ItemStack itemFirst, ItemStack itemSecond) {
        return itemFirst.func_77978_p() == null && itemSecond.func_77978_p() == null || itemFirst.func_77978_p() != null && itemSecond.func_77978_p() != null && itemFirst.func_77978_p().equals((Object)itemSecond.func_77978_p());
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void update() {
        NBTTagCompound tag = this.turtle.getUpgradeNBTData(this.side);
        tag.func_74768_a("maxSize", this.MAX_SIZE);
        tag.func_74768_a("stackSize", this.STACK_SIZE);
        tag.func_74768_a("currentUsage", this.CURRENT_USAGE);
        if (this.ITEM_TYPE_STORED == null) {
            tag.func_74757_a("isKnown", false);
        } else {
            tag.func_74757_a("isKnown", true);
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.ITEM_TYPE_STORED);
            tag.func_74778_a("itemID", itemId == null ? "" : itemId.toString());
            tag.func_74768_a("stackMeta", this.ITEM_META_STORED);
            if (this.itemStoredTag != null) {
                tag.func_74782_a("itemTag", (NBTBase)this.itemStoredTag);
            }
        }
        this.turtle.updateUpgradeNBTData(this.side);
        this.changed = false;
    }
}

