/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.blocks.BlockPppDirectional;
import com.austinv11.peripheralsplusplus.blocks.BlockTeleporter;
import com.austinv11.peripheralsplusplus.network.ParticlePacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import java.util.Stack;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityTeleporter
extends TileEntity
implements IPlusPlusPeripheral {
    private String name = "tileEntityTeleporter";
    public Stack<LinkData> links = new Stack();
    public String tag = null;

    public int getMaxLinks() {
        int tier = (Integer)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockTeleporter.TIER);
        return tier == 0 ? 1 : 8;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("tTag")) {
            this.tag = nbttagcompound.func_74779_i("tTag");
        }
        NBTTagList links = nbttagcompound.func_150295_c("links", 10);
        for (int i = 0; i < links.func_74745_c(); ++i) {
            NBTTagCompound link = links.func_150305_b(i);
            if (!link.func_74764_b("linkX") || !link.func_74764_b("linkY") || !link.func_74764_b("linkZ") || !link.func_74764_b("linkDim")) continue;
            this.links.add(new LinkData(link.func_74762_e("linkDim"), new BlockPos(link.func_74762_e("linkX"), link.func_74762_e("linkY"), link.func_74762_e("linkZ"))));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.tag != null) {
            nbttagcompound.func_74778_a("tTag", this.tag);
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.links.size(); ++i) {
            LinkData link = (LinkData)this.links.get(i);
            if (link == null) continue;
            NBTTagCompound lcompound = new NBTTagCompound();
            lcompound.func_74768_a("linkX", link.link.func_177958_n());
            lcompound.func_74768_a("linkY", link.link.func_177956_o());
            lcompound.func_74768_a("linkZ", link.link.func_177952_p());
            lcompound.func_74768_a("linkDim", link.linkDim);
            list.func_74742_a((NBTBase)lcompound);
        }
        nbttagcompound.func_74782_a("links", (NBTBase)list);
        return nbttagcompound;
    }

    public String getType() {
        return "teleporter";
    }

    public String[] getMethodNames() {
        return new String[]{"teleport", "tp", "getLinks", "setName"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableTurtleTeleporter) {
            throw new LuaException("Turtle teleporters have been disabled");
        }
        if (method == 0 || method == 1) {
            int index;
            if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                throw new LuaException("Bad argument #1 (expected number)");
            }
            int n = index = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) - 1 : 0;
            if (index < 0 || index >= this.getMaxLinks()) {
                throw new LuaException("Bad link " + (index + 1) + " (expected 1-" + this.getMaxLinks() + ")");
            }
            if (index >= this.links.size()) {
                throw new LuaException("No such link");
            }
            LinkData link = (LinkData)this.links.get(index);
            if (link == null) {
                throw new LuaException("No such link");
            }
            IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
            EnumFacing direction = (EnumFacing)blockState.func_177229_b((IProperty)BlockPppDirectional.field_176387_N);
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
            try {
                if (ReflectionHelper.getTurtle(te) == null) {
                    throw new LuaException("No turtle in front");
                }
            }
            catch (Exception e) {
                throw new LuaException("No turtle in front");
            }
            WorldServer destWorld = DimensionManager.getWorld((int)link.linkDim);
            if (destWorld == null) {
                throw new LuaException("Destination world missing");
            }
            TileEntity dest = destWorld.func_175625_s(link.link);
            if (!(dest instanceof TileEntityTeleporter)) {
                throw new LuaException("Destination is not a teleporter");
            }
            IBlockState destinationBlockState = this.field_145850_b.func_180495_p(dest.func_174877_v());
            EnumFacing destinationDirection = (EnumFacing)destinationBlockState.func_177229_b((IProperty)BlockPppDirectional.field_176387_N);
            BlockPos destinationPos = dest.func_174877_v().func_177972_a(destinationDirection);
            if (!destinationBlockState.func_177230_c().func_176200_f((IBlockAccess)destWorld, destinationPos) || destinationPos.func_177956_o() < 0 || destinationPos.func_177956_o() > 254) {
                throw new LuaException("Destination obstructed");
            }
            double distance = this.func_174877_v().func_177951_i((Vec3i)link.link);
            ITurtleAccess turtle = null;
            try {
                turtle = ReflectionHelper.getTurtle(te);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (turtle == null) {
                throw new LuaException("Could not get turtle");
            }
            double fuelUsed = distance * (double)Math.min(Math.max(Math.abs(this.field_145850_b.field_73011_w.getDimension() - destWorld.field_73011_w.getDimension()), 100), 1) * Config.teleporterPenalty;
            if (!turtle.consumeFuel(Math.abs((int)Math.ceil(fuelUsed)))) {
                throw new LuaException("Not enough fuel");
            }
            boolean result = turtle.teleportTo((World)destWorld, destinationPos);
            destWorld.markAndNotifyBlock(destinationPos, destWorld.func_175726_f(destinationPos), destinationBlockState, destinationBlockState, 2);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), blockState, blockState, 2);
            if (result) {
                BlockPos particlePos = this.field_174879_c.func_177972_a(direction);
                PeripheralsPlusPlus.NETWORK.sendToAllAround((IMessage)new ParticlePacket("portal", particlePos.func_177958_n(), particlePos.func_177956_o(), particlePos.func_177952_p(), this.field_145850_b.field_73012_v.nextGaussian(), 0.0, this.field_145850_b.field_73012_v.nextGaussian()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)particlePos.func_177958_n(), (double)particlePos.func_177956_o(), (double)particlePos.func_177952_p(), 16.0));
                this.field_145850_b.func_184134_a((double)particlePos.func_177958_n(), (double)particlePos.func_177956_o(), (double)particlePos.func_177952_p(), new SoundEvent(new ResourceLocation("minecraft", "mob.endermen.portal")), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
            return new Object[]{result};
        }
        if (method == 2) {
            HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
            for (int i = 0; i < this.links.size(); ++i) {
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("dim", ((LinkData)this.links.get((int)i)).linkDim);
                map2.put("x", ((LinkData)this.links.get((int)i)).link.func_177958_n());
                map2.put("y", ((LinkData)this.links.get((int)i)).link.func_177956_o());
                map2.put("z", ((LinkData)this.links.get((int)i)).link.func_177952_p());
                map2.put("name", this.name);
                map1.put(i, map2.clone());
            }
            return new Object[]{map1};
        }
        if (method == 3) {
            if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            this.name = (String)arguments[0];
            return new Object[]{this.name};
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public void blockActivated(EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (!held.func_190926_b() && held.func_77969_a(new ItemStack(Items.field_151107_aW))) {
            if (held.func_77978_p() != null && held.func_77978_p().func_74764_b("p++LinkX") && held.func_77978_p().func_74764_b("p++LinkY") && held.func_77978_p().func_74764_b("p++LinkZ") && held.func_77978_p().func_74764_b("p++LinkDim")) {
                BlockPos link = new BlockPos(held.func_77978_p().func_74762_e("p++LinkX"), held.func_77978_p().func_74762_e("p++LinkY"), held.func_77978_p().func_74762_e("p++LinkZ"));
                int linkDim = held.func_77978_p().func_74762_e("p++LinkDim");
                WorldServer srcWorld = DimensionManager.getWorld((int)linkDim);
                if (srcWorld == null) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Link failed: World is missing"));
                } else {
                    TileEntity te = srcWorld.func_175625_s(link);
                    if (!(te instanceof TileEntityTeleporter)) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Link failed: Teleporter no longer exists"));
                    } else {
                        TileEntityTeleporter src = (TileEntityTeleporter)te;
                        if (link.equals((Object)this.func_174877_v())) {
                            player.func_145747_a((ITextComponent)new TextComponentString("Link canceled"));
                        } else {
                            boolean unlinked = false;
                            for (int i = 0; i < src.links.size(); ++i) {
                                LinkData rlink = (LinkData)src.links.get(i);
                                if (!rlink.link.equals((Object)this.func_174877_v()) || rlink.linkDim != this.field_145850_b.field_73011_w.getDimension()) continue;
                                player.func_145747_a((ITextComponent)new TextComponentString("Unlinked teleporter at " + rlink.linkDim + ":(" + rlink.link.func_177958_n() + "," + rlink.link.func_177956_o() + "," + rlink.link.func_177952_p() + ") (link " + (i + 1) + ") from this teleporter"));
                                src.links.remove(i);
                                unlinked = true;
                                break;
                            }
                            if (!unlinked) {
                                src.addLink(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v());
                                player.func_145747_a((ITextComponent)new TextComponentString("Linked teleporter at " + linkDim + ":(" + link.func_177958_n() + "," + link.func_177956_o() + "," + link.func_177952_p() + ") (link " + src.links.size() + ") to this teleporter"));
                            }
                        }
                    }
                }
                held.func_77978_p().func_82580_o("p++LinkX");
                held.func_77978_p().func_82580_o("p++LinkY");
                held.func_77978_p().func_82580_o("p++LinkZ");
                held.func_77978_p().func_82580_o("p++LinkDim");
                if (held.func_77978_p().func_74764_b("display")) {
                    NBTTagCompound display = held.func_77978_p().func_74775_l("display");
                    display.func_82580_o("Lore");
                    if (display.func_82582_d()) {
                        held.func_77978_p().func_82580_o("display");
                    } else {
                        held.func_77978_p().func_74782_a("display", (NBTBase)display);
                    }
                }
                return;
            }
            if (held.func_77978_p() == null) {
                held.func_77982_d(new NBTTagCompound());
            }
            held.func_77978_p().func_74768_a("p++LinkX", this.func_174877_v().func_177958_n());
            held.func_77978_p().func_74768_a("p++LinkY", this.func_174877_v().func_177956_o());
            held.func_77978_p().func_74768_a("p++LinkZ", this.func_174877_v().func_177952_p());
            held.func_77978_p().func_74768_a("p++LinkDim", this.field_145850_b.field_73011_w.getDimension());
            NBTTagCompound display = new NBTTagCompound();
            NBTTagList lore = new NBTTagList();
            lore.func_74742_a((NBTBase)new NBTTagString("Turtle Teleporter Link"));
            lore.func_74742_a((NBTBase)new NBTTagString(this.field_145850_b.field_73011_w.getDimension() + ":(" + this.field_174879_c.func_177958_n() + "," + this.field_174879_c.func_177956_o() + "," + this.field_174879_c.func_177952_p() + ")"));
            display.func_74782_a("Lore", (NBTBase)lore);
            held.func_77978_p().func_74782_a("display", (NBTBase)display);
            player.func_145747_a((ITextComponent)new TextComponentString("Link started"));
        }
    }

    public int addLink(int linkDim, BlockPos link) {
        this.links.add(new LinkData(linkDim, link));
        while (this.links.size() > this.getMaxLinks()) {
            this.links.pop();
        }
        return this.links.size();
    }

    public static class LinkData {
        public int linkDim;
        public BlockPos link;

        public LinkData(int linkDim, BlockPos link) {
            this.linkDim = linkDim;
            this.link = link;
        }
    }
}

