/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.tiles.TileEntityInventory;
import com.austinv11.collectiveframework.utils.math.ThreeDimensionalVector;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ILensControl;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.IThrottledPacket;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.wand.IWandBindable;

@Optional.InterfaceList(value={@Optional.Interface(modid="botania", iface="vazkii.botania.api.mana.IManaPool"), @Optional.Interface(modid="botania", iface="vazkii.botania.api.mana.IManaSpreader"), @Optional.Interface(modid="botania", iface="vazkii.botania.api.mana.IManaCollector"), @Optional.Interface(modid="botania", iface="vazkii.botania.api.mana.spark.ISparkAttachable"), @Optional.Interface(modid="botania", iface="vazkii.botania.api.mana.IThrottledPacket"), @Optional.Interface(modid="botania", iface="vazkii.botania.api.wand.IWandBindable")})
public class TileEntityManaManipulator
extends TileEntityInventory
implements IPlusPlusPeripheral,
ITickable,
IManaPool,
IManaSpreader,
IManaCollector,
ISparkAttachable,
IThrottledPacket,
IWandBindable {
    private static final int MAX_MANA = 100000;
    private static final int EMPTY_LENS = -1;
    private boolean firstUpdate = true;
    private long lastAutoBurstTime;
    private IManaReceiver reciever;
    private EnumDyeColor manaPoolColor;
    private int manaHeld;
    private boolean canShootManaBurst;
    private int manaBurstParticleTick;
    private int manaBurstTicksExisted;
    private float rotationX;
    private float rotationY;
    private boolean autoBurst;
    private boolean voidExcessMana;
    private UUID attachedSpark;
    private UUID identity = UUID.randomUUID();
    private Color burstColor;
    private int lensSlot;

    public TileEntityManaManipulator() {
        this.lastAutoBurstTime = System.currentTimeMillis();
        this.manaPoolColor = EnumDyeColor.BLACK;
        this.burstColor = new Color((int)Math.floor(255.0 * Math.random()), (int)Math.floor(255.0 * Math.random()), (int)Math.floor(255.0 * Math.random()));
        this.invName = "peripheralsplusone:tile_entity_mana_manipulator";
        this.canShootManaBurst = true;
        this.lensSlot = -1;
    }

    public int getSize() {
        return 27;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(ModBlocks.MANA_MANIPULATOR.func_149739_a() + ".name", new Object[0]);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof ILens;
    }

    public void func_145843_s() {
        super.func_145843_s();
        ManaNetworkEvent.removePool((TileEntity)this);
        ManaNetworkEvent.removeCollector((TileEntity)this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ManaNetworkEvent.removePool((TileEntity)this);
        ManaNetworkEvent.removeCollector((TileEntity)this);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.manaPoolColor = EnumDyeColor.values()[compound.func_74762_e("manaPoolColor")];
        this.manaHeld = compound.func_74762_e("manaHeld");
        this.canShootManaBurst = compound.func_74767_n("canShootManaBurst");
        this.manaBurstParticleTick = compound.func_74762_e("manaBurstParticleTick");
        this.manaBurstTicksExisted = compound.func_74762_e("manaBurstTicksExisted");
        this.rotationX = compound.func_74760_g("rotationX");
        this.rotationY = compound.func_74760_g("rotationY");
        this.autoBurst = compound.func_74767_n("autoBurst");
        this.voidExcessMana = compound.func_74767_n("voidExcessMana");
        this.attachedSpark = compound.func_186857_a("attachedSpark");
        this.identity = compound.func_186857_a("identity");
        this.burstColor = new Color(compound.func_74762_e("burstColor"));
        this.lensSlot = compound.func_74762_e("lens");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("manaPoolColor", this.manaPoolColor.ordinal());
        compound.func_74768_a("manaHeld", this.manaHeld);
        compound.func_74757_a("canShootManaBurst", this.canShootManaBurst);
        compound.func_74768_a("manaBurstParticleTick", this.manaBurstParticleTick);
        compound.func_74768_a("manaBurstTicksExisted", this.manaBurstTicksExisted);
        compound.func_74776_a("rotationX", this.rotationX);
        compound.func_74776_a("rotationY", this.rotationY);
        compound.func_74757_a("autoBurst", this.autoBurst);
        compound.func_74757_a("voidExcessMana", this.voidExcessMana);
        if (this.attachedSpark != null) {
            compound.func_186854_a("attachedSpark", this.attachedSpark);
        }
        compound.func_186854_a("identity", this.identity);
        compound.func_74768_a("burstColor", this.burstColor.getRGB());
        compound.func_74768_a("lens", this.lensSlot);
        return compound;
    }

    private boolean tryShootBurst() {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastAutoBurstTime >= 100L && this.reciever != null && this.reciever.canRecieveManaFromBursts() && !this.reciever.isFull()) {
            IManaBurst burst = this.getBurst(false);
            if (burst != null) {
                this.recieveMana(-burst.getStartingMana());
                burst.setShooterUUID(this.getIdentifier());
                this.func_145831_w().func_72838_d((Entity)burst);
                burst.ping();
                this.field_145850_b.func_184133_a(null, this.field_174879_c, new SoundEvent(new ResourceLocation("botania", "spreaderfire")), SoundCategory.BLOCKS, 0.05f, (float)(0.7 + 0.3 * Math.random()));
                return true;
            }
            this.lastAutoBurstTime = System.currentTimeMillis();
        }
        return false;
    }

    private IManaBurst getBurst(boolean fake) {
        IManaBurst burst = this.getBotaniaBurstEntity(fake);
        BurstProperties properties = new BurstProperties(200, 100, 4.0f, 0.0f, 1.0f, this.burstColor.getRGB());
        if (burst != null) {
            ItemStack lens = this.getLens();
            if (!lens.func_190926_b() && lens.func_77973_b() instanceof ILensEffect) {
                ((ILensEffect)lens.func_77973_b()).apply(lens, properties);
            }
            burst.setSourceLens(lens);
        }
        if (burst != null && (this.getCurrentMana() >= 200 || fake)) {
            burst.setColor(properties.color);
            burst.setMana(properties.maxMana);
            burst.setStartingMana(properties.maxMana);
            burst.setMinManaLoss(properties.ticksBeforeManaLoss);
            burst.setManaLossPerTick(properties.manaLossPerTick);
            burst.setGravity(properties.gravity);
            return burst;
        }
        return null;
    }

    @Nullable
    private IManaBurst getBotaniaBurstEntity(boolean fake) {
        try {
            Constructor<?> botaniaBurst = Class.forName("vazkii.botania.common.entity.EntityManaBurst").getDeclaredConstructor(IManaSpreader.class, Boolean.TYPE);
            return (IManaBurst)botaniaBurst.newInstance(this, fake);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.updateReceiver();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    private void updateReceiver() {
        ItemStack lens = this.getLens();
        ILensControl control = this.getLensControl(lens);
        if (control != null && !control.allowBurstShooting(lens, (IManaSpreader)this, false)) {
            return;
        }
        IManaBurst simulation = this.getBurst(true);
        TileEntity receiver = this.getCollidedTile(simulation);
        this.reciever = receiver instanceof IManaReceiver && receiver.func_145830_o() && receiver.func_145831_w().func_175668_a(receiver.func_174877_v(), !receiver.func_145831_w().field_72995_K) ? (IManaReceiver)receiver : null;
    }

    @Nullable
    private TileEntity getCollidedTile(IManaBurst burst) {
        try {
            Method setScanBeam = burst.getClass().getDeclaredMethod("setScanBeam", new Class[0]);
            setScanBeam.invoke((Object)burst, new Object[0]);
            Method getCollidedTile = burst.getClass().getDeclaredMethod("getCollidedTile", Boolean.TYPE);
            return (TileEntity)getCollidedTile.invoke((Object)burst, true);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nonnull
    private ItemStack getLens() {
        if (this.lensSlot <= -1 || this.lensSlot >= this.items.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = this.func_70301_a(this.lensSlot);
        if (itemStack.func_190926_b()) {
            this.lensSlot = -1;
        }
        return itemStack;
    }

    @Nullable
    private ILensControl getLensControl(ItemStack lens) {
        ILensControl control;
        if (!lens.func_190926_b() && lens.func_77973_b() instanceof ILensControl && (control = (ILensControl)lens.func_77973_b()).isControlLens(lens)) {
            return control;
        }
        return null;
    }

    private int getFirstMatchingLensIndex(ItemStack lens) {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.func_77969_a(lens)) continue;
            return this.items.indexOf((Object)itemStack);
        }
        return -1;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, -999, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    private double getAngle(ThreeDimensionalVector first, ThreeDimensionalVector other) {
        return Math.acos(this.normalize(first).dotProduct(this.normalize(other)));
    }

    private ThreeDimensionalVector normalize(ThreeDimensionalVector vector) {
        double mag = Math.sqrt(vector.getX() * vector.getX() + vector.getY() * vector.getY() + vector.getZ() * vector.getZ());
        if (mag != 0.0) {
            double multiplier = 1.0 / mag;
            return new ThreeDimensionalVector(vector.getX() * multiplier, vector.getY() * multiplier, vector.getZ() * multiplier);
        }
        return vector;
    }

    public void func_73660_a() {
        if (this.firstUpdate) {
            ManaNetworkEvent.addPool((TileEntity)this);
            ManaNetworkEvent.addCollector((TileEntity)this);
            this.updateReceiver();
            this.firstUpdate = false;
        }
        this.updateReceiver();
        ItemStack lens = this.getLens();
        ILensControl control = this.getLensControl(lens);
        boolean canShoot = true;
        if (control != null && this.autoBurst) {
            control.onControlledSpreaderTick(lens, (IManaSpreader)this, false);
            canShoot = control.allowBurstShooting(lens, (IManaSpreader)this, false);
        }
        if (this.autoBurst && canShoot) {
            this.tryShootBurst();
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Nonnull
    public String getType() {
        return "mana_tank";
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"getMana", "sendBurst", "setBurstDirection", "getBurstDirection", "setAutoBurst", "getAutoBurst", "setVoidExcessMana", "getVoidExcessMana", "setColor", "getColor", "setLens", "getLens", "getContainedLenses"};
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return this.getMana(arguments);
            }
            case 1: {
                return this.sendBurst();
            }
            case 2: {
                return this.setBurstDirection(arguments);
            }
            case 3: {
                return this.getBurstDirection();
            }
            case 4: {
                return this.setAutoBurst(arguments);
            }
            case 5: {
                return this.getAutoBurst();
            }
            case 6: {
                return this.setVoidExcessMana(arguments);
            }
            case 7: {
                return this.getVoidExcessMana();
            }
            case 8: {
                return this.setColorLua(arguments);
            }
            case 9: {
                return this.getColorLua();
            }
            case 10: {
                return this.setLensLua(arguments);
            }
            case 11: {
                return this.getLensLua();
            }
            case 12: {
                return this.getContainedLensesLua();
            }
        }
        throw new LuaException("Unexpected error.");
    }

    private Object[] getContainedLensesLua() {
        HashMap map = new HashMap();
        int lensIndex = 1;
        for (ItemStack itemStack : this.items) {
            if (itemStack.func_190926_b()) continue;
            HashMap<String, Object> nestedMap = new HashMap<String, Object>();
            ResourceLocation regName = itemStack.func_77973_b().getRegistryName();
            nestedMap.put("id", regName == null ? "null" : regName.toString());
            nestedMap.put("meta", itemStack.func_77960_j());
            nestedMap.put("name", itemStack.func_82833_r());
            nestedMap.put("slot", this.items.indexOf((Object)itemStack));
            nestedMap.put("nbt", itemStack.func_77978_p() == null ? null : itemStack.func_77978_p().toString());
            map.put(lensIndex++, nestedMap);
        }
        return new Object[]{map};
    }

    private Object[] getLensLua() {
        ItemStack lens = this.getLens();
        if (lens.func_190926_b()) {
            return new Object[0];
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResourceLocation regName = lens.func_77973_b().getRegistryName();
        map.put("id", regName == null ? "null" : regName.toString());
        map.put("meta", lens.func_77960_j());
        map.put("name", lens.func_82833_r());
        map.put("slot", this.lensSlot);
        map.put("nbt", lens.func_77978_p() == null ? null : lens.func_77978_p().toString());
        return new Object[]{map};
    }

    private Object[] setLensLua(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            throw new LuaException("Not enough arguments");
        }
        if (arguments.length < 2) {
            if (!(arguments[0] instanceof Double)) {
                throw new LuaException("Argument 1 should be an integer");
            }
            int slotIndex = ((Double)arguments[0]).intValue();
            ItemStack itemStack = this.func_70301_a(slotIndex);
            if (itemStack.func_190926_b()) {
                throw new LuaException("Slot is empty");
            }
            this.lensSlot = slotIndex;
        } else {
            if (!(arguments[0] instanceof String)) {
                throw new LuaException("Argument 1 should be a string");
            }
            if (!(arguments[1] instanceof Double)) {
                throw new LuaException("Argument 2 should be an integer");
            }
            int meta = ((Double)arguments[1]).intValue();
            ItemStack itemStack = GameRegistry.makeItemStack((String)((String)arguments[0]), (int)meta, (int)1, (String)"");
            int slotIndex = this.getFirstMatchingLensIndex(itemStack);
            if (slotIndex <= -1) {
                throw new LuaException("Lens not found in inventory");
            }
            this.lensSlot = slotIndex;
        }
        return new Object[0];
    }

    private Object[] getColorLua() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("r", this.burstColor.getRed());
        map.put("g", this.burstColor.getGreen());
        map.put("b", this.burstColor.getBlue());
        return new Object[]{map};
    }

    private Object[] setColorLua(Object[] arguments) throws LuaException {
        if (arguments.length < 3) {
            throw new LuaException("Not enough arguments");
        }
        for (Object arg : arguments) {
            if (arg instanceof Double) continue;
            throw new LuaException(String.format("Argument %d is expected to be a number", Arrays.asList(arguments).indexOf(arg)));
        }
        this.burstColor = new Color(((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue());
        return new Object[0];
    }

    private Object[] getVoidExcessMana() {
        return new Object[]{this.voidExcessMana};
    }

    private Object[] setVoidExcessMana(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof Boolean)) {
            throw new LuaException("Argument 1 expected to be boolean");
        }
        this.voidExcessMana = (Boolean)arguments[0];
        return new Object[0];
    }

    private Object[] getAutoBurst() {
        return new Object[]{this.autoBurst};
    }

    private Object[] getBurstDirection() {
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("x", Float.valueOf(this.rotationX));
        map.put("y", Float.valueOf(this.rotationY));
        return new Object[]{map};
    }

    private Object[] setAutoBurst(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof Boolean)) {
            throw new LuaException("Argument 1 expected to be boolean");
        }
        this.autoBurst = (Boolean)arguments[0];
        return new Object[0];
    }

    private Object[] setBurstDirection(Object[] arguments) throws LuaException {
        if (arguments.length < 2) {
            throw new LuaException("Not enough arguments");
        }
        if (!(arguments[0] instanceof Double)) {
            throw new LuaException("Argument 1 expected to be a number");
        }
        if (!(arguments[1] instanceof Double)) {
            throw new LuaException("Argument 2 expected to be an number");
        }
        this.rotationX = ((Double)arguments[0]).floatValue();
        this.rotationY = ((Double)arguments[1]).floatValue();
        this.commitRedirection();
        return new Object[0];
    }

    private Object[] sendBurst() {
        ItemStack lens = this.getLens();
        ILensControl control = this.getLensControl(lens);
        boolean canShoot = true;
        if (control != null) {
            control.onControlledSpreaderTick(lens, (IManaSpreader)this, false);
            canShoot = control.allowBurstShooting(lens, (IManaSpreader)this, false);
        }
        boolean result = false;
        if (canShoot) {
            result = this.tryShootBurst();
        }
        return new Object[]{result};
    }

    private Object[] getMana(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            arguments = new Object[]{false};
        }
        if (!(arguments[0] instanceof Boolean)) {
            throw new LuaException("Argument 1 is expected to be boolean");
        }
        return new Object[]{(Boolean)arguments[0] != false ? this.manaHeld : this.field_145850_b.field_73012_v.nextInt(this.manaHeld + 1)};
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public EnumDyeColor getColor() {
        return this.manaPoolColor;
    }

    public void setColor(EnumDyeColor color) {
        this.manaPoolColor = color;
    }

    public boolean isFull() {
        return this.manaHeld >= 100000;
    }

    public void recieveMana(int mana) {
        this.manaHeld += mana;
        this.manaHeld = Math.min(this.manaHeld, 100000);
    }

    public boolean canRecieveManaFromBursts() {
        return this.voidExcessMana || !this.isFull();
    }

    public int getCurrentMana() {
        return this.manaHeld;
    }

    public void setCanShoot(boolean canShoot) {
        this.canShootManaBurst = canShoot;
    }

    public int getBurstParticleTick() {
        return this.manaBurstParticleTick;
    }

    public void setBurstParticleTick(int tick) {
        this.manaBurstParticleTick = tick;
    }

    public int getLastBurstDeathTick() {
        return this.manaBurstTicksExisted;
    }

    public void setLastBurstDeathTick(int ticksExisted) {
        this.manaBurstTicksExisted = ticksExisted;
    }

    public IManaBurst runBurstSimulation() {
        IManaBurst burst = this.getBurst(true);
        if (burst != null) {
            this.getCollidedTile(burst);
        }
        return burst;
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public void setRotationX(float rot) {
        this.rotationX = rot;
    }

    public void setRotationY(float rot) {
        this.rotationY = rot;
    }

    public void commitRedirection() {
        this.updateReceiver();
    }

    public void pingback(IManaBurst burst, UUID expectedIdentity) {
        this.lastAutoBurstTime = System.currentTimeMillis();
    }

    public UUID getIdentifier() {
        return this.identity;
    }

    public void onClientDisplayTick() {
    }

    public float getManaYieldMultiplier(IManaBurst burst) {
        return 0.9f;
    }

    public int getMaxMana() {
        return 100000;
    }

    public boolean canAttachSpark(ItemStack stack) {
        return this.getAttachedSpark() == null;
    }

    public void attachSpark(ISparkEntity entity) {
        if (entity instanceof Entity) {
            this.attachedSpark = ((Entity)entity).getPersistentID();
        }
    }

    public int getAvailableSpaceForMana() {
        return Math.max(Math.abs(100000 - this.manaHeld), 0);
    }

    public ISparkEntity getAttachedSpark() {
        List entities = this.func_145831_w().func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()));
        for (Entity entity : entities) {
            if (!(entity instanceof ISparkEntity) || !entity.getPersistentID().equals(this.attachedSpark)) continue;
            return (ISparkEntity)entity;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.isFull();
    }

    public void markDispatchable() {
    }

    public boolean canSelect(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        Vec3d from = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
        Vec3d to = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
        AxisAlignedBB axis = player.field_70170_p.func_180495_p(pos).func_185890_d((IBlockAccess)player.field_70170_p, pos);
        axis = axis != null ? axis.func_186670_a(pos) : new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
        if (!axis.func_72318_a(to)) {
            to = new Vec3d(axis.field_72340_a + (axis.field_72336_d - axis.field_72340_a) / 2.0, axis.field_72338_b + (axis.field_72337_e - axis.field_72338_b) / 2.0, axis.field_72339_c + (axis.field_72334_f - axis.field_72339_c) / 2.0);
        }
        ThreeDimensionalVector diff = new ThreeDimensionalVector(to.field_72450_a, to.field_72448_b, to.field_72449_c).subtract(new ThreeDimensionalVector(from.field_72450_a, from.field_72448_b, from.field_72449_c));
        ThreeDimensionalVector diff2d = new ThreeDimensionalVector(diff.getX(), diff.getZ(), 0.0);
        ThreeDimensionalVector rotate = new ThreeDimensionalVector(0.0, 1.0, 0.0);
        double angle = this.getAngle(rotate, diff2d) / Math.PI * 180.0;
        if (to.field_72450_a < from.field_72450_a) {
            angle *= -1.0;
        }
        System.out.println(angle + 90.0);
        this.setRotationX((float)(360.0 - (angle + 90.0)));
        rotate = new ThreeDimensionalVector(diff.getX(), 0.0, diff.getZ());
        angle = this.getAngle(diff, rotate) * 180.0 / Math.PI;
        if (to.field_72448_b < from.field_72448_b) {
            angle *= -1.0;
        }
        this.setRotationY((float)angle);
        this.commitRedirection();
        return true;
    }

    public BlockPos getBinding() {
        if (this.reciever != null) {
            return ((TileEntity)this.reciever).func_174877_v();
        }
        return null;
    }
}

